/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state.hooks;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.HookEntityId;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.node.app.hapi.utils.contracts.HookUtils;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HtsSystemContract;
import com.hedera.node.app.service.contract.impl.state.AbstractProxyEvmAccount;
import com.hedera.node.app.service.contract.impl.state.EvmFrameState;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.code.CodeFactory;

public class ProxyEvmHook
extends AbstractProxyEvmAccount {
    private final EvmHookState hookState;
    private final CodeFactory codeFactory;
    private final EntityIdFactory entityIdFactory;

    public ProxyEvmHook(@NonNull EvmFrameState state, @NonNull EvmHookState hookState, CodeFactory codeFactory, @NonNull EntityIdFactory entityIdFactory) {
        super(ProxyEvmHook.getOwnerId(hookState.hookIdOrThrow()), state);
        this.hookState = Objects.requireNonNull(hookState);
        this.codeFactory = codeFactory;
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
    }

    @Override
    @NonNull
    public Code getEvmCode(@NonNull Bytes functionSelector, @NonNull CodeFactory codeFactory) {
        return codeFactory.createCode(this.getCode(), false);
    }

    @Override
    public Address getAddress() {
        return HtsSystemContract.HTS_HOOKS_CONTRACT_ADDRESS;
    }

    @Override
    @NonNull
    public ContractID hederaContractId() {
        return this.entityIdFactory.newContractId(365L);
    }

    @NonNull
    public Bytes getCode() {
        return this.state.getCode(this.hookState.hookContractIdOrThrow());
    }

    @NonNull
    public Hash getCodeHash() {
        return this.state.getCodeHash(this.hookState.hookContractIdOrThrow(), this.codeFactory);
    }

    @Override
    @NonNull
    public UInt256 getStorageValue(@NonNull UInt256 key) {
        return this.state.getStorageValue(this.entityIdFactory.newContractId(365L), key);
    }

    @NonNull
    private static AccountID getOwnerId(@NonNull HookId hookId) {
        return HookUtils.getHookOwnerId((HookEntityId)hookId.entityIdOrThrow());
    }

    @Override
    public boolean isRegularAccount() {
        return false;
    }
}

