/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.util;

import com.esaulpaugh.headlong.util.Strings;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class Integers {
    private Integers() {
    }

    public static byte[] toBytes(byte val) {
        byte[] byArray;
        if (val != 0) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = val;
        } else {
            byArray = Strings.EMPTY_BYTE_ARRAY;
        }
        return byArray;
    }

    public static byte[] toBytes(short val) {
        int len = Integers.len(val);
        byte[] bytes = new byte[len];
        Integers.putLong(val, len, bytes, 0);
        return bytes;
    }

    public static byte[] toBytes(int val) {
        int len = Integers.len(val);
        byte[] bytes = new byte[len];
        Integers.putLong(val, len, bytes, 0);
        return bytes;
    }

    public static byte[] toBytes(long val) {
        int len = Integers.len(val);
        byte[] bytes = new byte[len];
        Integers.putLong(val, len, bytes, 0);
        return bytes;
    }

    public static byte[] toBytesUnsigned(BigInteger val) {
        byte[] bytes = new byte[Integers.len(val)];
        Integers.putBigInt(val, bytes, 0);
        return bytes;
    }

    public static int putByte(byte val, byte[] o, int i) {
        if (val != 0) {
            o[i] = val;
            return 1;
        }
        return 0;
    }

    public static int putShort(short val, byte[] o, int i) {
        return Integers.putLong(val, Integers.len(val), o, i);
    }

    public static int putInt(int val, byte[] o, int i) {
        return Integers.putLong(val, Integers.len(val), o, i);
    }

    public static int putLong(long val, byte[] o, int i) {
        return Integers.putLong(val, Integers.len(val), o, i);
    }

    public static int putLong(long val, ByteBuffer o) {
        return Integers.putLong(val, Integers.len(val), o);
    }

    public static int putLong(long val, int len, byte[] o, int index) {
        int i = index;
        switch (len) {
            case 8: {
                o[i++] = (byte)(val >>> 56);
            }
            case 7: {
                o[i++] = (byte)(val >>> 48);
            }
            case 6: {
                o[i++] = (byte)(val >>> 40);
            }
            case 5: {
                o[i++] = (byte)(val >>> 32);
            }
            case 4: {
                o[i++] = (byte)(val >>> 24);
            }
            case 3: {
                o[i++] = (byte)(val >>> 16);
            }
            case 2: {
                o[i++] = (byte)(val >>> 8);
            }
            case 1: {
                o[i++] = (byte)val;
            }
            case 0: {
                return i - index;
            }
        }
        throw Integers.outOfRangeException(len);
    }

    public static int putLong(long val, int len, ByteBuffer o) {
        switch (len) {
            case 8: {
                o.put((byte)(val >>> 56));
            }
            case 7: {
                o.put((byte)(val >>> 48));
            }
            case 6: {
                o.put((byte)(val >>> 40));
            }
            case 5: {
                o.put((byte)(val >>> 32));
            }
            case 4: {
                o.put((byte)(val >>> 24));
            }
            case 3: {
                o.put((byte)(val >>> 16));
            }
            case 2: {
                o.put((byte)(val >>> 8));
            }
            case 1: {
                o.put((byte)val);
            }
            case 0: {
                return len;
            }
        }
        throw Integers.outOfRangeException(len);
    }

    public static byte getByte(byte[] buffer, int offset, int len, boolean lenient) {
        switch (len) {
            case 1: {
                byte lead = buffer[offset];
                if (!lenient && lead == 0) {
                    throw Integers.leadingZeroException(offset, len);
                }
                return lead;
            }
            case 0: {
                return 0;
            }
        }
        throw Integers.outOfRangeException(len);
    }

    public static short getShort(byte[] buffer, int offset, int len, boolean lenient) {
        int shiftAmount = 0;
        int val = 0;
        switch (len) {
            case 2: {
                val = buffer[offset + 1] & 0xFF;
                shiftAmount = 8;
            }
            case 1: {
                byte lead = buffer[offset];
                if (!lenient && lead == 0) {
                    throw Integers.leadingZeroException(offset, len);
                }
                val |= (lead & 0xFF) << shiftAmount;
            }
            case 0: {
                return (short)val;
            }
        }
        throw Integers.outOfRangeException(len);
    }

    public static int getInt(byte[] buffer, int offset, int len, boolean lenient) {
        int shiftAmount = 0;
        int val = 0;
        switch (len) {
            case 4: {
                val = buffer[offset + 3] & 0xFF;
                shiftAmount = 8;
            }
            case 3: {
                val |= (buffer[offset + 2] & 0xFF) << shiftAmount;
                shiftAmount += 8;
            }
            case 2: {
                val |= (buffer[offset + 1] & 0xFF) << shiftAmount;
                shiftAmount += 8;
            }
            case 1: {
                byte lead = buffer[offset];
                if (!lenient && lead == 0) {
                    throw Integers.leadingZeroException(offset, len);
                }
                val |= (lead & 0xFF) << shiftAmount;
            }
            case 0: {
                return val;
            }
        }
        throw Integers.outOfRangeException(len);
    }

    public static long getLong(byte[] buffer, int offset, int len, boolean lenient) {
        int shiftAmount = 0;
        long val = 0L;
        switch (len) {
            case 8: {
                val = (long)buffer[offset + 7] & 0xFFL;
                shiftAmount = 8;
            }
            case 7: {
                val |= ((long)buffer[offset + 6] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 6: {
                val |= ((long)buffer[offset + 5] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 5: {
                val |= ((long)buffer[offset + 4] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 4: {
                val |= ((long)buffer[offset + 3] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 3: {
                val |= ((long)buffer[offset + 2] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 2: {
                val |= ((long)buffer[offset + 1] & 0xFFL) << shiftAmount;
                shiftAmount += 8;
            }
            case 1: {
                byte lead = buffer[offset];
                if (!lenient && lead == 0) {
                    throw Integers.leadingZeroException(offset, len);
                }
                val |= ((long)lead & 0xFFL) << shiftAmount;
            }
            case 0: {
                return val;
            }
        }
        throw Integers.outOfRangeException(len);
    }

    private static IllegalArgumentException leadingZeroException(int idx, int len) {
        return new IllegalArgumentException("deserialized integers with leading zeroes are invalid; index: " + idx + ", len: " + len);
    }

    private static IllegalArgumentException outOfRangeException(int len) {
        return new IllegalArgumentException("len is out of range: " + len);
    }

    public static int len(byte val) {
        return val != 0 ? 1 : 0;
    }

    public static int len(short val) {
        if (val != 0) {
            if (val >> 8 != 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static int len(int val) {
        return (32 - Integer.numberOfLeadingZeros(val) + 7) / 8;
    }

    public static int len(long val) {
        return (Integers.bitLen(val) + 7) / 8;
    }

    public static int len(BigInteger val) {
        return (val.bitLength() + 7) / 8;
    }

    public static int bitLen(long val) {
        return 64 - Long.numberOfLeadingZeros(val);
    }

    public static BigInteger getBigInt(byte[] buffer, int offset, int len, boolean lenient) {
        if (len != 0) {
            if (!lenient && buffer[offset] == 0) {
                throw Integers.leadingZeroException(offset, len);
            }
            byte[] arr = new byte[len];
            System.arraycopy(buffer, offset, arr, 0, len);
            return new BigInteger(1, arr);
        }
        return BigInteger.ZERO;
    }

    public static int putBigInt(BigInteger val, byte[] dest, int destIdx) {
        byte[] bytes = val.toByteArray();
        int len = bytes.length;
        if (bytes[0] == 0) {
            System.arraycopy(bytes, 1, dest, destIdx, --len);
        } else {
            System.arraycopy(bytes, 0, dest, destIdx, len);
        }
        return len;
    }

    public static int mod(int val, int powerOfTwo) {
        return val & powerOfTwo - 1;
    }

    public static int roundLengthUp(int len, int powerOfTwo) {
        return -powerOfTwo & len + (powerOfTwo - 1);
    }

    public static boolean isMultiple(int val, int powerOfTwo) {
        return Integers.mod(val, powerOfTwo) == 0;
    }

    public static void checkIsMultiple(int val, int powerOfTwo) {
        if (!Integers.isMultiple(val, powerOfTwo)) {
            throw new IllegalArgumentException("expected length mod " + powerOfTwo + " == 0, found: " + val % powerOfTwo);
        }
    }
}

