/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import java.util.Optional;

public final class NativeImageHelper {
    private static final String SYS_PROP_IMAGE_CODE = "org.graalvm.nativeimage.imagecode";
    private static final String BUILD_TIME = "buildtime";
    private static final String RUNTIME = "runtime";

    private NativeImageHelper() {
    }

    public static boolean isRuntime() {
        return NativeImageHelper.property().map(RUNTIME::equals).orElse(false);
    }

    public static boolean isBuildTime() {
        return NativeImageHelper.property().map(BUILD_TIME::equals).orElse(false);
    }

    public static boolean isNativeImage() {
        return NativeImageHelper.property().isPresent();
    }

    private static Optional<String> property() {
        return Optional.ofNullable(System.getProperty(SYS_PROP_IMAGE_CODE));
    }
}

