/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.ethereum.rlp;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.ethereum.rlp.RLPEncodingHelpers;
import org.hyperledger.besu.ethereum.rlp.RLPOutput;

abstract class AbstractRLPOutput
implements RLPOutput {
    private static final Bytes LIST_MARKER = Bytes.wrap((byte[])new byte[0]);
    private final List<Bytes> values = new ArrayList<Bytes>();
    private final BitSet rlpEncoded = new BitSet();
    private int[] payloadSizes = new int[8];
    private int listsCount = 1;
    private int[] parentListStack = new int[4];
    private int stackSize = 1;

    AbstractRLPOutput() {
    }

    private int currentList() {
        return this.parentListStack[this.stackSize - 1];
    }

    @Override
    public void writeBytes(Bytes v) {
        Preconditions.checkState((this.stackSize > 1 || this.values.isEmpty() ? 1 : 0) != 0, (Object)"Terminated RLP output, cannot add more elements");
        this.values.add(v);
        int n = this.currentList();
        this.payloadSizes[n] = this.payloadSizes[n] + RLPEncodingHelpers.elementSize(v);
    }

    @Override
    public void writeRaw(Bytes v) {
        Preconditions.checkState((this.stackSize > 1 || this.values.isEmpty() ? 1 : 0) != 0, (Object)"Terminated RLP output, cannot add more elements");
        this.values.add(v);
        this.rlpEncoded.set(this.values.size() - 1);
        int n = this.currentList();
        this.payloadSizes[n] = this.payloadSizes[n] + v.size();
    }

    @Override
    public void startList() {
        this.values.add(LIST_MARKER);
        ++this.listsCount;
        ++this.stackSize;
        if (this.listsCount > this.payloadSizes.length) {
            this.payloadSizes = Arrays.copyOf(this.payloadSizes, this.payloadSizes.length * 3 / 2);
        }
        if (this.stackSize > this.parentListStack.length) {
            this.parentListStack = Arrays.copyOf(this.parentListStack, this.parentListStack.length * 3 / 2);
        }
        this.parentListStack[this.stackSize - 1] = this.listsCount - 1;
    }

    @Override
    public void endList() {
        int newCurrent;
        Preconditions.checkState((this.stackSize > 1 ? 1 : 0) != 0, (Object)"LeaveList() called with no prior matching startList()");
        int current = this.currentList();
        int finishedListSize = RLPEncodingHelpers.listSize(this.payloadSizes[current]);
        --this.stackSize;
        int n = newCurrent = this.currentList();
        this.payloadSizes[n] = this.payloadSizes[n] + finishedListSize;
    }

    public int encodedSize() {
        Preconditions.checkState((this.stackSize == 1 ? 1 : 0) != 0, (Object)"A list has been entered (startList()) but not left (endList())");
        return this.payloadSizes[0];
    }

    public void writeEncoded(MutableBytes mutableBytes) {
        if (this.listsCount == 1) {
            int finalOffset;
            assert (this.values.size() == 1);
            Bytes value = this.values.get(0);
            if (this.rlpEncoded.get(0)) {
                value.copyTo(mutableBytes, 0);
                finalOffset = value.size();
            } else {
                finalOffset = RLPEncodingHelpers.writeElement(value, mutableBytes, 0);
            }
            Preconditions.checkState((finalOffset == mutableBytes.size() ? 1 : 0) != 0, (String)"Expected single element RLP encode to be of size %s but was of size %s.", (int)mutableBytes.size(), (int)finalOffset);
            return;
        }
        int offset = 0;
        int listIdx = 0;
        for (int i = 0; i < this.values.size(); ++i) {
            Bytes value = this.values.get(i);
            if (value == LIST_MARKER) {
                int payloadSize = this.payloadSizes[++listIdx];
                offset = RLPEncodingHelpers.writeListHeader(payloadSize, mutableBytes, offset);
                continue;
            }
            if (this.rlpEncoded.get(i)) {
                value.copyTo(mutableBytes, offset);
                offset += value.size();
                continue;
            }
            offset = RLPEncodingHelpers.writeElement(value, mutableBytes, offset);
        }
        Preconditions.checkState((offset == mutableBytes.size() ? 1 : 0) != 0, (String)"Expected RLP encoding to be of size %s but was of size %s.", (int)mutableBytes.size(), (int)offset);
    }
}

