/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.socket.SocketContext;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameListener;
import io.helidon.http.http2.Http2GoAway;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2Ping;
import io.helidon.http.http2.Http2Priority;
import io.helidon.http.http2.Http2RstStream;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2WindowUpdate;

public class Http2LoggingFrameListener
implements Http2FrameListener {
    private final String prefix;
    private final System.Logger logger;

    public Http2LoggingFrameListener(String prefix) {
        this.prefix = prefix;
        this.logger = System.getLogger(Http2LoggingFrameListener.class.getName() + "." + prefix);
    }

    @Override
    public void frameHeader(SocketContext ctx, int streamId, BufferData headerData) {
        if (this.logger.isLoggable(System.Logger.Level.TRACE)) {
            ctx.log(this.logger, System.Logger.Level.TRACE, "%s %d: frame header data%n%s", new Object[]{this.prefix, streamId, headerData.debugDataHex(true)});
        }
    }

    @Override
    public void frameHeader(SocketContext ctx, int streamId, Http2FrameHeader frameHeader) {
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            String flagsString = frameHeader.typedFlags().toString();
            ctx.log(this.logger, System.Logger.Level.DEBUG, "%s %d: %s frame <length=%d, stream_id=%d, flags=%s active_flags=%s>", new Object[]{this.prefix, streamId, frameHeader.type(), frameHeader.length(), frameHeader.streamId(), BufferData.toBinaryString((int)frameHeader.flags()), flagsString});
        }
    }

    @Override
    public void frame(SocketContext ctx, int streamId, BufferData data) {
        if (this.logger.isLoggable(System.Logger.Level.TRACE)) {
            if (data.available() == 0) {
                ctx.log(this.logger, System.Logger.Level.TRACE, "%s %d: frame data - empty", new Object[]{this.prefix, streamId});
            } else {
                ctx.log(this.logger, System.Logger.Level.TRACE, "%s %d: frame data, %n%s", new Object[]{this.prefix, streamId, data.debugDataHex(true)});
            }
        }
    }

    @Override
    public void frame(SocketContext ctx, int streamId, Http2Priority priority) {
        ctx.log(this.logger, System.Logger.Level.DEBUG, "%s %d: (dep_stream_id: %s, weight: %d, exclusive: %s)", new Object[]{this.prefix, streamId, priority.streamId(), priority.weight(), priority.exclusive()});
    }

    @Override
    public void frame(SocketContext ctx, int streamId, Http2RstStream rstStream) {
        ctx.log(this.logger, System.Logger.Level.DEBUG, "%s %d: (rstStream: %s)", new Object[]{this.prefix, streamId, rstStream.errorCode()});
    }

    @Override
    public void frame(SocketContext ctx, int streamId, Http2Settings settings) {
        ctx.log(this.logger, System.Logger.Level.DEBUG, "%s %d: %s", new Object[]{this.prefix, streamId, settings});
    }

    @Override
    public void frame(SocketContext ctx, int streamId, Http2Ping ping) {
        if (this.logger.isLoggable(System.Logger.Level.TRACE)) {
            ctx.log(this.logger, System.Logger.Level.TRACE, "%s %d: ping%n%s", new Object[]{this.prefix, streamId, BufferData.create((byte[])ping.getBytes()).debugDataHex(true)});
        }
    }

    @Override
    public void frame(SocketContext ctx, int streamId, Http2GoAway go) {
        if (this.logger.isLoggable(System.Logger.Level.DEBUG)) {
            if (go.errorCode() == Http2ErrorCode.NO_ERROR) {
                ctx.log(this.logger, System.Logger.Level.DEBUG, "%s %d: (last_stream_id=%d, errorCode=%s)", new Object[]{this.prefix, streamId, go.lastStreamId(), go.errorCode()});
            } else {
                ctx.log(this.logger, System.Logger.Level.DEBUG, "%s %d: (last_stream_id=%d, errorCode=%s)%n%s", new Object[]{this.prefix, streamId, go.lastStreamId(), go.errorCode(), go.details()});
            }
        }
    }

    @Override
    public void frame(SocketContext ctx, int streamId, Http2WindowUpdate windowUpdate) {
        ctx.log(this.logger, System.Logger.Level.DEBUG, "%s %d: (size_increment=%d)%n", new Object[]{this.prefix, streamId, windowUpdate.windowSizeIncrement()});
    }

    @Override
    public void headers(SocketContext ctx, int streamId, Http2Headers headers) {
        if (this.logger.isLoggable(System.Logger.Level.TRACE)) {
            ctx.log(this.logger, System.Logger.Level.TRACE, "%s %d: headers:%n%s", new Object[]{this.prefix, streamId, headers.toString()});
        }
    }
}

