/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class Http2Util {
    private static final byte[] PRIOR_KNOWLEDGE_PREFACE = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(StandardCharsets.UTF_8);
    public static final int PREFACE_LENGTH = PRIOR_KNOWLEDGE_PREFACE.length;

    private Http2Util() {
    }

    public static boolean isPreface(byte[] bytes) {
        return Arrays.compare(PRIOR_KNOWLEDGE_PREFACE, 0, PREFACE_LENGTH, bytes, 0, PREFACE_LENGTH) == 0;
    }

    public static BufferData prefaceData() {
        return BufferData.create((byte[])PRIOR_KNOWLEDGE_PREFACE);
    }
}

