/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history;

import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.hapi.node.state.history.HistorySignature;
import com.hedera.node.app.service.roster.impl.ActiveRosters;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface ReadableHistoryStore {
    @Nullable
    public Bytes getLedgerId();

    @NonNull
    public HistoryProofConstruction getActiveConstruction();

    @NonNull
    public HistoryProofConstruction getNextConstruction();

    default public boolean isReadyToAdopt(@NonNull Bytes rosterHash) {
        HistoryProofConstruction construction = this.getNextConstruction();
        return construction.hasTargetProof() && construction.targetRosterHash().equals((Object)rosterHash);
    }

    @Nullable
    public HistoryProofConstruction getConstructionFor(@NonNull ActiveRosters var1);

    @NonNull
    public Map<Long, HistoryProofVote> getVotes(long var1, @NonNull Set<Long> var3);

    @NonNull
    public List<ProofKeyPublication> getProofKeyPublications(@NonNull Set<Long> var1);

    @NonNull
    public List<HistorySignaturePublication> getSignaturePublications(long var1, @NonNull Set<Long> var3);

    public record HistorySignaturePublication(long nodeId, @NonNull HistorySignature signature, @NonNull Instant at) {
        public HistorySignaturePublication {
            Objects.requireNonNull(signature);
            Objects.requireNonNull(at);
        }
    }

    public record ProofKeyPublication(long nodeId, @NonNull Bytes proofKey, @NonNull Instant adoptionTime) {
        public ProofKeyPublication {
            Objects.requireNonNull(proofKey);
            Objects.requireNonNull(adoptionTime);
        }
    }
}

