/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.cryptography.rpm.SigningAndVerifyingSchnorrKeys;
import com.hedera.node.app.history.HistoryLibrary;
import com.hedera.node.app.history.impl.ProofKeysAccessor;
import com.hedera.node.app.tss.SequentialContentManager;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProofKeysAccessorImpl
implements ProofKeysAccessor,
SequentialContentManager.ContentReader<SchnorrKeyPair>,
SequentialContentManager.ContentWriter<SchnorrKeyPair> {
    private static final String SUB_DIRECTORY = "wraps";
    private static final String FILE_CONTENT = "Schnorr key pair";
    private static final String FILE_NAME = "schnorr.bin";
    private final HistoryLibrary library;
    private final Supplier<Configuration> config;
    private volatile SequentialContentManager<SchnorrKeyPair> contentManager;

    @Inject
    public ProofKeysAccessorImpl(@NonNull HistoryLibrary library, @NonNull Supplier<Configuration> config) {
        this.config = Objects.requireNonNull(config);
        this.library = Objects.requireNonNull(library);
    }

    @Override
    public Bytes sign(long constructionId, @NonNull Bytes message) {
        Objects.requireNonNull(message);
        SchnorrKeyPair keyPair = this.contentManager().getOrCreateContent(constructionId);
        return this.library.signSchnorr(message, keyPair.privateKey());
    }

    @Override
    public SchnorrKeyPair getOrCreateSchnorrKeyPair(long constructionId) {
        return this.contentManager().getOrCreateContent(constructionId);
    }

    @Override
    @NonNull
    public SchnorrKeyPair readContent(@NonNull Path p) throws IOException {
        Objects.requireNonNull(p);
        byte[] bytes = Files.readAllBytes(p);
        return SchnorrKeyPair.fromDelimited(bytes);
    }

    @Override
    public void writeContent(@NonNull SchnorrKeyPair content, @NonNull Path p) throws IOException {
        Objects.requireNonNull(content);
        Objects.requireNonNull(p);
        Files.write(p, content.toDelimitedBytes(), new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private SequentialContentManager<SchnorrKeyPair> contentManager() {
        if (this.contentManager == null) {
            ProofKeysAccessorImpl proofKeysAccessorImpl = this;
            synchronized (proofKeysAccessorImpl) {
                if (this.contentManager == null) {
                    Path pathToKeys = FileUtils.getAbsolutePath((String)((TssConfig)this.config.get().getConfigData(TssConfig.class)).tssKeysPath()).resolve(SUB_DIRECTORY);
                    this.contentManager = new SequentialContentManager<SchnorrKeyPair>(pathToKeys, FILE_CONTENT, FILE_NAME, () -> SchnorrKeyPair.from(this.library.newSchnorrKeyPair()), this, this);
                }
            }
        }
        return this.contentManager;
    }

    public record SchnorrKeyPair(Bytes privateKey, Bytes publicKey) {
        public static SchnorrKeyPair from(@NonNull SigningAndVerifyingSchnorrKeys keys) {
            return new SchnorrKeyPair(Bytes.wrap((byte[])keys.signingKey()), Bytes.wrap((byte[])keys.verifyingKey()));
        }

        public static SchnorrKeyPair fromDelimited(@NonNull byte[] bytes) {
            byte m = bytes[0];
            byte[] privateKey = new byte[m];
            System.arraycopy(bytes, 1, privateKey, 0, m);
            byte n = bytes[m + 1];
            byte[] publicKey = new byte[n];
            System.arraycopy(bytes, m + 2, publicKey, 0, n);
            return new SchnorrKeyPair(Bytes.wrap((byte[])privateKey), Bytes.wrap((byte[])publicKey));
        }

        public byte[] toDelimitedBytes() {
            int m = (int)this.privateKey.length();
            int n = (int)this.publicKey.length();
            byte[] bytes = new byte[2 + m + n];
            bytes[0] = (byte)m;
            System.arraycopy(this.privateKey.toByteArray(), 0, bytes, 1, m);
            bytes[m + 1] = (byte)n;
            System.arraycopy(this.publicKey.toByteArray(), 0, bytes, m + 2, n);
            return bytes;
        }
    }
}

