/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockrecords.BlockInfo;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import org.hiero.base.crypto.DigestType;

public final class BlockRecordInfoUtils {
    public static final int HASH_SIZE = DigestType.SHA_384.digestLength();

    private BlockRecordInfoUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    @Nullable
    public static Instant firstConsTimeOfLastBlock(@NonNull BlockInfo blockInfo) {
        Timestamp firstConsTimeOfLastBlock = blockInfo.firstConsTimeOfLastBlock();
        return firstConsTimeOfLastBlock != null ? Instant.ofEpochSecond(firstConsTimeOfLastBlock.seconds(), firstConsTimeOfLastBlock.nanos()) : null;
    }

    @Nullable
    public static Bytes lastBlockHash(@NonNull BlockInfo blockInfo) {
        return BlockRecordInfoUtils.getLastBlockHash(blockInfo);
    }

    @Nullable
    public static Bytes blockHashByBlockNumber(@NonNull BlockInfo blockInfo, long blockNo) {
        return BlockRecordInfoUtils.blockHashByBlockNumber(blockInfo.blockHashes(), blockInfo.lastBlockNumber(), blockNo);
    }

    @Nullable
    public static Bytes blockHashByBlockNumber(@NonNull Bytes blockHashes, long lastBlockNo, long blockNo) {
        long blocksAvailable = blockHashes.length() / (long)HASH_SIZE;
        if (blockNo < 0L) {
            return null;
        }
        long firstAvailableBlockNo = lastBlockNo - blocksAvailable + 1L;
        if (blockNo < firstAvailableBlockNo || blockNo > lastBlockNo) {
            return null;
        }
        long offset = (blockNo - firstAvailableBlockNo) * (long)HASH_SIZE;
        return blockHashes.slice(offset, (long)HASH_SIZE);
    }

    @Nullable
    private static Bytes getLastBlockHash(@Nullable BlockInfo blockInfo) {
        Bytes runningBlockHashes;
        if (blockInfo != null && (runningBlockHashes = blockInfo.blockHashes()) != null && runningBlockHashes.length() >= (long)HASH_SIZE) {
            return runningBlockHashes.slice(runningBlockHashes.length() - (long)HASH_SIZE, (long)HASH_SIZE);
        }
        return null;
    }
}

