/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state;

import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.WrappedWritableKVState;
import com.swirlds.state.spi.WrappedWritableQueueState;
import com.swirlds.state.spi.WrappedWritableSingletonState;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class WrappedWritableStates
implements WritableStates {
    private final WritableStates delegate;
    private final Map<Integer, WrappedWritableKVState<?, ?>> writableKVStateMap = new HashMap();
    private final Map<Integer, WrappedWritableSingletonState<?>> writableSingletonStateMap = new HashMap();
    private final Map<Integer, WrappedWritableQueueState<?>> writableQueueStateMap = new HashMap();

    public WrappedWritableStates(@NonNull WritableStates delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
    }

    public boolean contains(int stateId) {
        return this.delegate.contains(stateId);
    }

    @NonNull
    public Set<Integer> stateIds() {
        return this.delegate.stateIds();
    }

    @NonNull
    public <K, V> WritableKVState<K, V> get(int stateId) {
        return (WritableKVState)this.writableKVStateMap.computeIfAbsent(stateId, s -> new WrappedWritableKVState(this.delegate.get(stateId)));
    }

    @NonNull
    public <T> WritableSingletonState<T> getSingleton(int stateId) {
        return (WritableSingletonState)this.writableSingletonStateMap.computeIfAbsent(stateId, s -> new WrappedWritableSingletonState(this.delegate.getSingleton(stateId)));
    }

    @NonNull
    public <E> WritableQueueState<E> getQueue(int stateId) {
        return (WritableQueueState)this.writableQueueStateMap.computeIfAbsent(stateId, s -> new WrappedWritableQueueState(this.delegate.getQueue(stateId)));
    }

    public boolean isModified() {
        for (WrappedWritableKVState<?, ?> wrappedWritableKVState : this.writableKVStateMap.values()) {
            if (!wrappedWritableKVState.isModified()) continue;
            return true;
        }
        for (WrappedWritableQueueState wrappedWritableQueueState : this.writableQueueStateMap.values()) {
            if (!wrappedWritableQueueState.isModified()) continue;
            return true;
        }
        for (WrappedWritableSingletonState wrappedWritableSingletonState : this.writableSingletonStateMap.values()) {
            if (!wrappedWritableSingletonState.isModified()) continue;
            return true;
        }
        return false;
    }

    public void commit(boolean commitSingletons) {
        WritableStates writableStates;
        this.writableKVStateMap.keySet().stream().sorted().forEach(stateId -> this.writableKVStateMap.get(stateId).commit());
        this.writableQueueStateMap.keySet().stream().sorted().forEach(stateId -> this.writableQueueStateMap.get(stateId).commit());
        if (commitSingletons) {
            this.writableSingletonStateMap.keySet().stream().sorted().forEach(stateId -> this.writableSingletonStateMap.get(stateId).commit());
        }
        if ((writableStates = this.delegate) instanceof CommittableWritableStates) {
            CommittableWritableStates terminalStates = (CommittableWritableStates)writableStates;
            terminalStates.commit();
        }
    }
}

