/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.recordcache;

import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.node.app.spi.records.RecordCache;
import com.hedera.node.app.spi.records.RecordSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class PartialRecordSource
implements RecordSource {
    private final List<TransactionRecord> precomputedRecords;
    private final List<RecordSource.IdentifiedReceipt> identifiedReceipts;

    public PartialRecordSource() {
        this.precomputedRecords = new ArrayList<TransactionRecord>();
        this.identifiedReceipts = new ArrayList<RecordSource.IdentifiedReceipt>();
    }

    public PartialRecordSource(@NonNull TransactionRecord precomputedRecord) {
        this(List.of(precomputedRecord));
    }

    public PartialRecordSource(@NonNull List<TransactionRecord> precomputedRecords) {
        Objects.requireNonNull(precomputedRecords);
        this.precomputedRecords = Objects.requireNonNull(precomputedRecords);
        this.identifiedReceipts = new ArrayList<RecordSource.IdentifiedReceipt>();
        for (TransactionRecord precomputed : precomputedRecords) {
            this.identifiedReceipts.add(new RecordSource.IdentifiedReceipt(precomputed.transactionIDOrThrow(), precomputed.receiptOrThrow()));
        }
    }

    public void incorporate(@NonNull TransactionRecord precomputedRecord) {
        Objects.requireNonNull(precomputedRecord);
        this.precomputedRecords.add(precomputedRecord);
    }

    public List<RecordSource.IdentifiedReceipt> identifiedReceipts() {
        return this.identifiedReceipts;
    }

    public void forEachTxnRecord(@NonNull Consumer<TransactionRecord> action) {
        Objects.requireNonNull(action);
        this.precomputedRecords.forEach(action);
    }

    public TransactionReceipt receiptOf(@NonNull TransactionID txnId) {
        Objects.requireNonNull(txnId);
        for (TransactionRecord precomputed : this.precomputedRecords) {
            if (!txnId.equals((Object)precomputed.transactionIDOrThrow())) continue;
            return precomputed.receiptOrThrow();
        }
        throw new IllegalArgumentException();
    }

    public List<TransactionReceipt> childReceiptsOf(@NonNull TransactionID txnId) {
        Objects.requireNonNull(txnId);
        return this.precomputedRecords.stream().filter(r -> RecordCache.isChild((TransactionID)txnId, (TransactionID)r.transactionIDOrThrow())).map(TransactionRecord::receiptOrThrow).toList();
    }
}

