/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.query;

import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.node.app.components.QueryInjectionComponent;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.service.consensus.impl.handlers.ConsensusHandlers;
import com.hedera.node.app.service.contract.impl.handlers.ContractHandlers;
import com.hedera.node.app.service.file.impl.handlers.FileHandlers;
import com.hedera.node.app.service.networkadmin.impl.handlers.NetworkAdminHandlers;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleHandlers;
import com.hedera.node.app.service.token.impl.handlers.TokenHandlers;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.records.RecordCache;
import com.hedera.node.app.state.WorkingStateAccessor;
import com.hedera.node.app.throttle.SynchronizedThrottleAccumulator;
import com.hedera.node.app.workflows.OpWorkflowMetrics;
import com.hedera.node.app.workflows.ingest.IngestChecker;
import com.hedera.node.app.workflows.ingest.SubmissionManager;
import com.hedera.node.app.workflows.query.QueryChecker;
import com.hedera.node.app.workflows.query.QueryDispatcher;
import com.hedera.node.app.workflows.query.QueryHandlers;
import com.hedera.node.app.workflows.query.QueryWorkflow;
import com.hedera.node.app.workflows.query.QueryWorkflowImpl;
import com.hedera.node.app.workflows.query.annotations.OperatorQueries;
import com.hedera.node.app.workflows.query.annotations.UserQueries;
import com.hedera.node.config.ConfigProvider;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.state.State;
import dagger.Module;
import dagger.Provides;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.InstantSource;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Singleton;

@Module(subcomponents={QueryInjectionComponent.class})
public interface QueryWorkflowInjectionModule {
    public static final Runnable NO_OP = () -> {};

    @Provides
    @Singleton
    @UserQueries
    public static QueryWorkflow provideUserQueryWorkflow(@NonNull Function<ResponseType, AutoCloseableWrapper<State>> stateAccessor, @NonNull SubmissionManager submissionManager, @NonNull QueryChecker queryChecker, @NonNull IngestChecker ingestChecker, @NonNull QueryDispatcher dispatcher, @NonNull Codec<Query> queryParser, @NonNull ConfigProvider configProvider, @NonNull RecordCache recordCache, @NonNull Authorizer authorizer, @NonNull ExchangeRateManager exchangeRateManager, @NonNull FeeManager feeManager, @NonNull SynchronizedThrottleAccumulator synchronizedThrottleAccumulator, @NonNull InstantSource instantSource, @NonNull OpWorkflowMetrics opWorkflowMetrics) {
        return new QueryWorkflowImpl(stateAccessor, submissionManager, queryChecker, ingestChecker, dispatcher, queryParser, configProvider, recordCache, authorizer, exchangeRateManager, feeManager, synchronizedThrottleAccumulator, instantSource, opWorkflowMetrics, true);
    }

    @Provides
    @Singleton
    @OperatorQueries
    public static QueryWorkflow provideOperatorQueryWorkflow(@NonNull Function<ResponseType, AutoCloseableWrapper<State>> stateAccessor, @NonNull SubmissionManager submissionManager, @NonNull QueryChecker queryChecker, @NonNull IngestChecker ingestChecker, @NonNull QueryDispatcher dispatcher, @NonNull Codec<Query> queryParser, @NonNull ConfigProvider configProvider, @NonNull RecordCache recordCache, @NonNull Authorizer authorizer, @NonNull ExchangeRateManager exchangeRateManager, @NonNull FeeManager feeManager, @NonNull SynchronizedThrottleAccumulator synchronizedThrottleAccumulator, @NonNull InstantSource instantSource, @NonNull OpWorkflowMetrics opWorkflowMetrics) {
        return new QueryWorkflowImpl(stateAccessor, submissionManager, queryChecker, ingestChecker, dispatcher, queryParser, configProvider, recordCache, authorizer, exchangeRateManager, feeManager, synchronizedThrottleAccumulator, instantSource, opWorkflowMetrics, false);
    }

    @Provides
    @Singleton
    public static Function<ResponseType, AutoCloseableWrapper<State>> provideStateAccess(@NonNull WorkingStateAccessor workingStateAccessor) {
        return responseType -> new AutoCloseableWrapper((Object)workingStateAccessor.getState(), NO_OP);
    }

    @Provides
    public static QueryHandlers provideQueryHandlers(@NonNull ConsensusHandlers consensusHandlers, @NonNull FileHandlers fileHandlers, @NonNull NetworkAdminHandlers networkHandlers, @NonNull Supplier<ContractHandlers> contractHandlers, @NonNull ScheduleHandlers scheduleHandlers, @NonNull TokenHandlers tokenHandlers) {
        return new QueryHandlers(consensusHandlers.consensusGetTopicInfoHandler(), contractHandlers.get().contractGetBySolidityIDHandler(), contractHandlers.get().contractCallLocalHandler(), contractHandlers.get().contractGetInfoHandler(), contractHandlers.get().contractGetBytecodeHandler(), contractHandlers.get().contractGetRecordsHandler(), tokenHandlers.cryptoGetAccountBalanceHandler(), tokenHandlers.cryptoGetAccountInfoHandler(), tokenHandlers.cryptoGetAccountRecordsHandler(), tokenHandlers.cryptoGetLiveHashHandler(), tokenHandlers.cryptoGetStakersHandler(), fileHandlers.fileGetContentsHandler(), fileHandlers.fileGetInfoHandler(), networkHandlers.networkGetAccountDetailsHandler(), networkHandlers.networkGetByKeyHandler(), networkHandlers.networkGetExecutionTimeHandler(), networkHandlers.networkGetVersionInfoHandler(), networkHandlers.networkTransactionGetReceiptHandler(), networkHandlers.networkTransactionGetRecordHandler(), networkHandlers.networkTransactionGetFastRecordHandler(), scheduleHandlers.scheduleGetInfoHandler(), tokenHandlers.tokenGetInfoHandler(), tokenHandlers.tokenGetAccountNftInfosHandler(), tokenHandlers.tokenGetNftInfoHandler(), tokenHandlers.tokenGetNftInfosHandler());
    }

    @Provides
    public static Codec<Query> provideQueryParser() {
        return Query.PROTOBUF;
    }
}

