/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.impl.schemas.V0490TokenSchema;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class ReadableNftStoreImpl
implements ReadableNftStore {
    private final ReadableKVState<NftID, Nft> nftState;
    private final ReadableEntityCounters entityCounters;

    public ReadableNftStoreImpl(@NonNull ReadableStates states, @NonNull ReadableEntityCounters entityCounters) {
        Objects.requireNonNull(states);
        this.entityCounters = Objects.requireNonNull(entityCounters);
        this.nftState = states.get(V0490TokenSchema.NFTS_STATE_ID);
    }

    @Nullable
    public Nft get(@NonNull NftID nftId) {
        Objects.requireNonNull(nftId);
        return (Nft)this.nftState.get((Object)nftId);
    }

    public long sizeOfState() {
        return this.entityCounters.getCounterFor(EntityType.NFT);
    }

    public void warm(@NonNull NftID nftID) {
        this.nftState.warm((Object)nftID);
    }
}

