/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.comparator;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.util.HapiUtils;
import java.util.Comparator;
import java.util.Objects;

public final class TokenComparators {
    public static final Comparator<Account> ACCOUNT_COMPARATOR = Comparator.comparing(Account::accountId, HapiUtils.ACCOUNT_ID_COMPARATOR);
    public static final Comparator<AccountAmount> ACCOUNT_AMOUNT_COMPARATOR = Comparator.comparing(AccountAmount::accountID, HapiUtils.ACCOUNT_ID_COMPARATOR);
    public static final Comparator<TokenID> TOKEN_ID_COMPARATOR = Comparator.comparingLong(TokenID::tokenNum);
    public static final Comparator<NftID> NFT_ID_COMPARATOR = Comparator.comparing(NftID::tokenIdOrThrow, TOKEN_ID_COMPARATOR).thenComparingLong(NftID::serialNumber);
    public static final Comparator<PendingAirdropId> PENDING_AIRDROP_ID_COMPARATOR = Comparator.comparing(PendingAirdropId::receiverIdOrThrow, HapiUtils.ACCOUNT_ID_COMPARATOR).thenComparing(PendingAirdropId::senderIdOrThrow, HapiUtils.ACCOUNT_ID_COMPARATOR).thenComparing(PendingAirdropId::tokenReference, (a, b) -> {
        int ordinalComparison = Integer.compare(((PendingAirdropId.TokenReferenceOneOfType)a.kind()).protoOrdinal(), ((PendingAirdropId.TokenReferenceOneOfType)b.kind()).protoOrdinal());
        if (ordinalComparison != 0) {
            return ordinalComparison;
        }
        if (a.kind() == PendingAirdropId.TokenReferenceOneOfType.FUNGIBLE_TOKEN_TYPE) {
            return TOKEN_ID_COMPARATOR.compare((TokenID)a.as(), (TokenID)b.as());
        }
        return NFT_ID_COMPARATOR.compare((NftID)a.as(), (NftID)b.as());
    });
    public static final Comparator<TokenTransferList> TOKEN_TRANSFER_LIST_COMPARATOR = (o1, o2) -> Objects.compare(o1.token(), o2.token(), TOKEN_ID_COMPARATOR);
    public static final Comparator<NftTransfer> NFT_TRANSFER_COMPARATOR = Comparator.comparing(NftTransfer::senderAccountID, HapiUtils.ACCOUNT_ID_COMPARATOR).thenComparing(NftTransfer::receiverAccountID, HapiUtils.ACCOUNT_ID_COMPARATOR).thenComparing(NftTransfer::serialNumber);

    private TokenComparators() {
        throw new UnsupportedOperationException("Utility Class");
    }
}

