/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.TokenUpdateNftsTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableNftStore;
import com.hedera.node.app.service.token.impl.handlers.TokenUpdateHandler;
import com.hedera.node.app.service.token.impl.validators.TokenAttributesValidator;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenUpdateNftsHandler
implements TransactionHandler {
    private final TokenAttributesValidator validator;

    @Inject
    public TokenUpdateNftsHandler(@NonNull TokenAttributesValidator validator) {
        this.validator = validator;
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        TokenUpdateNftsTransactionBody op = txn.tokenUpdateNftsOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasToken(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        PreCheckException.validateTruePreCheck((!op.serialNumbers().isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MISSING_SERIAL_NUMBERS);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenUpdateNftsTransactionBody op = txn.tokenUpdateNftsOrThrow();
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        Token token = tokenStore.get(op.tokenOrElse(TokenID.DEFAULT));
        PreCheckException.validateTruePreCheck((token != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        ReadableNftStore nftStore = (ReadableNftStore)context.createStore(ReadableNftStore.class);
        if (this.serialNumbersInTreasury(token.treasuryAccountIdOrThrow(), op.serialNumbers(), nftStore, token.tokenIdOrThrow())) {
            PreCheckException.validateTruePreCheck((token.hasMetadataKey() || token.hasSupplyKey() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_HAS_NO_METADATA_OR_SUPPLY_KEY);
            if (token.hasMetadataKey() && token.hasSupplyKey()) {
                context.requireKey(TokenUpdateHandler.oneOf(token.metadataKeyOrThrow(), token.supplyKeyOrThrow()));
            } else if (token.hasMetadataKey()) {
                context.requireKey(token.metadataKeyOrThrow());
            } else if (token.hasSupplyKey()) {
                context.requireKey(token.supplyKeyOrThrow());
            }
        } else {
            PreCheckException.validateTruePreCheck((boolean)token.hasMetadataKey(), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_HAS_NO_METADATA_KEY);
            context.requireKey(token.metadataKeyOrThrow());
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        TransactionBody txnBody = context.body();
        TokenUpdateNftsTransactionBody op = txnBody.tokenUpdateNftsOrThrow();
        TokenID tokenId = op.tokenOrThrow();
        StoreFactory storeFactory = context.storeFactory();
        WritableNftStore nftStore = (WritableNftStore)storeFactory.writableStore(WritableNftStore.class);
        this.validateSemantics(context, op);
        LinkedHashSet<Long> nftSerialNums = new LinkedHashSet<Long>(op.serialNumbers());
        HandleException.validateTrue(((long)nftSerialNums.size() <= nftStore.sizeOfState() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
        this.updateNftMetadata(nftSerialNums, nftStore, tokenId, op);
    }

    private void updateNftMetadata(@NonNull Set<Long> nftSerialNums, @NonNull WritableNftStore nftStore, @NonNull TokenID tokenNftId, @NonNull TokenUpdateNftsTransactionBody op) {
        for (Long nftSerialNumber : nftSerialNums) {
            HandleException.validateTrue((nftSerialNumber > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER);
            Nft nft = nftStore.get(tokenNftId, nftSerialNumber);
            HandleException.validateTrue((nft != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
            if (!op.hasMetadata()) continue;
            Nft updatedNft = nft.copyBuilder().metadata(op.metadataOrThrow()).build();
            nftStore.put(updatedNft);
        }
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TransactionBody op = feeContext.body();
        List serials = op.tokenUpdateNftsOrThrow().serialNumbers();
        FeeCalculator feeCalculator = feeContext.feeCalculatorFactory().feeCalculator(SubType.TOKEN_NON_FUNGIBLE_UNIQUE);
        feeCalculator.resetUsage();
        return feeCalculator.addBytesPerTransaction((long)serials.size()).calculate();
    }

    private void validateSemantics(@NonNull HandleContext context, @NonNull TokenUpdateNftsTransactionBody op) {
        TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        if (op.hasMetadata()) {
            this.validator.validateTokenMetadata(op.metadataOrThrow(), tokensConfig);
        }
        HandleException.validateTrue((op.serialNumbers().size() <= tokensConfig.nftsMaxBatchSizeUpdate() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.BATCH_SIZE_LIMIT_EXCEEDED);
    }

    private boolean serialNumbersInTreasury(@NonNull AccountID treasuryAccount, @NonNull List<Long> serialNumbers, @NonNull ReadableNftStore nftStore, @NonNull TokenID tokenId) throws PreCheckException {
        boolean serialNumbersInTreasury = true;
        for (Long serialNumber : serialNumbers) {
            Nft nft = nftStore.get(NftID.newBuilder().tokenId(tokenId).serialNumber(serialNumber.longValue()).build());
            PreCheckException.validateTruePreCheck((nft != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
            if (nft.ownerId() == null || Objects.equals(nft.ownerId(), treasuryAccount)) continue;
            serialNumbersInTreasury = false;
            break;
        }
        return serialNumbersInTreasury;
    }
}

