/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.util;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;

public class CryptoTransferHelper {
    private CryptoTransferHelper() {
        throw new UnsupportedOperationException("Utility class only");
    }

    public static TokenTransferList createFungibleTransfer(TokenID tokenId, AccountID fromAccount, long amount, AccountID toAccount) {
        return TokenTransferList.newBuilder().token(tokenId).transfers(new AccountAmount[]{AccountAmount.newBuilder().accountID(fromAccount).amount(-amount).build(), AccountAmount.newBuilder().accountID(toAccount).amount(amount).build()}).build();
    }

    public static AccountAmount createAccountAmount(AccountID account, long amount, boolean isApproval) {
        return AccountAmount.newBuilder().accountID(account).amount(amount).isApproval(isApproval).build();
    }

    public static TokenTransferList createNftTransfer(TokenID tokenId, NftTransfer nftTransfer) {
        return TokenTransferList.newBuilder().token(tokenId).nftTransfers(new NftTransfer[]{nftTransfer}).build();
    }

    public static TokenTransferList createNftTransfer(TokenID tokenId, List<NftTransfer> nftTransfers) {
        return TokenTransferList.newBuilder().token(tokenId).nftTransfers(nftTransfers).build();
    }

    public static NftTransfer nftTransfer(@NonNull AccountID from, @NonNull AccountID to, long serialNo) {
        return NftTransfer.newBuilder().serialNumber(serialNo).senderAccountID(from).receiverAccountID(to).build();
    }
}

