/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.Main;
import io.helidon.common.Weight;
import io.helidon.service.registry.ServiceRegistryManager;
import io.helidon.spi.HelidonShutdownHandler;
import io.helidon.spi.HelidonStartupProvider;

@Weight(value=100.0)
public class RegistryStartupProvider
implements HelidonStartupProvider {
    @Deprecated
    public RegistryStartupProvider() {
    }

    public static void registerShutdownHandler(ServiceRegistryManager registryManager) {
        System.Logger logger = System.getLogger(RegistryStartupProvider.class.getName());
        Main.addShutdownHandler((HelidonShutdownHandler)new RegistryShutdownHandler(logger, registryManager));
    }

    public void start(String[] arguments) {
        ServiceRegistryManager.start();
    }

    @Weight(value=110.0)
    private static final class RegistryShutdownHandler
    implements HelidonShutdownHandler {
        private final System.Logger logger;
        private final ServiceRegistryManager registryManager;

        private RegistryShutdownHandler(System.Logger logger, ServiceRegistryManager registryManager) {
            this.logger = logger;
            this.registryManager = registryManager;
        }

        public void shutdown() {
            try {
                this.registryManager.shutdown();
            }
            catch (Exception e) {
                this.logger.log(System.Logger.Level.ERROR, "Failed to shutdown Helidon Service Registry registry", (Throwable)e);
            }
        }

        public String toString() {
            return "Helidon Service Registry shutdown handler";
        }
    }
}

