/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.Weighted;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.service.registry.Binding;
import io.helidon.service.registry.Bindings;
import io.helidon.service.registry.CoreServiceDiscovery;
import io.helidon.service.registry.CoreServiceRegistry;
import io.helidon.service.registry.Dependency;
import io.helidon.service.registry.DependencyPlanBinder;
import io.helidon.service.registry.DescriptorHandler;
import io.helidon.service.registry.EmptyBinding;
import io.helidon.service.registry.FactoryType;
import io.helidon.service.registry.GeneratedService;
import io.helidon.service.registry.GlobalServiceRegistry;
import io.helidon.service.registry.InterceptionMetadata;
import io.helidon.service.registry.InterceptionMetadata__ServiceDescriptor;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.RegistryStartupProvider;
import io.helidon.service.registry.Scopes;
import io.helidon.service.registry.Scopes__ServiceDescriptor;
import io.helidon.service.registry.Service;
import io.helidon.service.registry.ServiceDescriptor;
import io.helidon.service.registry.ServiceDiscovery;
import io.helidon.service.registry.ServiceInfo;
import io.helidon.service.registry.ServiceLoader__ServiceDescriptor;
import io.helidon.service.registry.ServiceRegistry;
import io.helidon.service.registry.ServiceRegistryConfig;
import io.helidon.service.registry.ServiceRegistryException;
import io.helidon.service.registry.ServiceRegistry__ServiceDescriptor;
import io.helidon.service.registry.VirtualDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ServiceRegistryManager {
    static final Comparator<ServiceInfo> SERVICE_INFO_COMPARATOR = Comparator.comparingDouble(Weighted::weight).reversed().thenComparing((f, s) -> {
        if (f.qualifiers().isEmpty() && s.qualifiers().isEmpty()) {
            return 0;
        }
        if (f.qualifiers().isEmpty()) {
            return -1;
        }
        if (s.qualifiers().isEmpty()) {
            return 1;
        }
        return 0;
    }).thenComparing(ServiceInfo::serviceType);
    private static final System.Logger LOGGER = System.getLogger(ServiceRegistryManager.class.getName());
    private final ReentrantReadWriteLock lifecycleLock = new ReentrantReadWriteLock();
    private final ServiceRegistryConfig config;
    private final ServiceDiscovery discovery;
    private CoreServiceRegistry registry;

    ServiceRegistryManager(ServiceRegistryConfig config, ServiceDiscovery serviceDiscovery) {
        this.config = config;
        this.discovery = serviceDiscovery;
    }

    public static ServiceRegistryManager start(Binding binding, ServiceRegistryConfig config) {
        ServiceRegistryConfig.Builder configBuilder = (ServiceRegistryConfig.Builder)ServiceRegistryConfig.builder(config).update(binding::configure);
        if (!config.runLevels().isEmpty()) {
            configBuilder.runLevels(config.runLevels());
        }
        ServiceRegistryConfig updatedConfig = configBuilder.build();
        ServiceRegistryManager manager = ServiceRegistryManager.create(updatedConfig);
        return ServiceRegistryManager.boundManager(binding, updatedConfig, manager);
    }

    public static ServiceRegistryManager start(ServiceRegistryConfig config) {
        ServiceRegistryManager manager = ServiceRegistryManager.start(new NoOpBinding(), config);
        ServiceRegistry registry = manager.registry();
        if (config.runLevels().isEmpty()) {
            double maxRunLevel = config.maxRunLevel();
            List<Double> runLevels = registry.lookupServices(Lookup.EMPTY).stream().map(ServiceInfo::runLevel).flatMap(Optional::stream).distinct().sorted().collect(Collectors.toUnmodifiableList());
            ServiceRegistryManager.initializeRunLevels(registry, maxRunLevel, runLevels);
        }
        return manager;
    }

    public static ServiceRegistryManager start(Binding binding) {
        ServiceRegistryConfig config = ((ServiceRegistryConfig.Builder)((ServiceRegistryConfig.Builder)((ServiceRegistryConfig.Builder)ServiceRegistryConfig.builder().discoverServices(false)).discoverServicesFromServiceLoader(false)).update(binding::configure)).build();
        if (binding instanceof EmptyBinding) {
            return ServiceRegistryManager.start(config);
        }
        ServiceRegistryManager manager = ServiceRegistryManager.create(config);
        return ServiceRegistryManager.boundManager(binding, config, manager);
    }

    public static ServiceRegistryManager start() {
        return ServiceRegistryManager.start(ServiceRegistryConfig.create());
    }

    public static ServiceRegistryManager create() {
        return ServiceRegistryManager.create(ServiceRegistryConfig.create());
    }

    public static ServiceRegistryManager create(ServiceRegistryConfig config) {
        ServiceDiscovery discovery = config.discoverServices() || config.discoverServicesFromServiceLoader() ? CoreServiceDiscovery.create(config) : CoreServiceDiscovery.noop();
        return new ServiceRegistryManager(config, discovery);
    }

    public ServiceRegistry registry() {
        return this.registry(new NoOpBinding());
    }

    public void shutdown() {
        ReentrantReadWriteLock.WriteLock lock = this.lifecycleLock.writeLock();
        try {
            lock.lock();
            if (this.registry == null) {
                return;
            }
            ServiceRegistry global = GlobalServiceRegistry.registry();
            if (global == this.registry) {
                GlobalServiceRegistry.unset(this.registry);
            }
            this.registry.shutdown();
            this.registry = null;
        }
        finally {
            lock.unlock();
        }
    }

    private static void initializeRunLevels(ServiceRegistry registry, double maxRunLevel, List<Double> runLevels) {
        for (Double runLevel : runLevels) {
            if (runLevel > maxRunLevel) break;
            List all = registry.all(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addScope(Service.Singleton.TYPE)).runLevel(runLevel)).build());
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Starting services in run level: " + runLevel + ": ");
                for (Object o : all) {
                    LOGGER.log(System.Logger.Level.DEBUG, "\t" + String.valueOf(o));
                }
            } else if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.TRACE, "Starting services in run level: " + runLevel);
            }
            all = registry.all(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addScope(Service.PerLookup.TYPE)).runLevel(runLevel)).build());
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.DEBUG, "Starting per lookup services in run level: " + runLevel + ": ");
                for (Object o : all) {
                    LOGGER.log(System.Logger.Level.DEBUG, "\t" + String.valueOf(o));
                }
                continue;
            }
            if (!LOGGER.isLoggable(System.Logger.Level.DEBUG)) continue;
            LOGGER.log(System.Logger.Level.TRACE, "Starting per lookup services in run level: " + runLevel);
        }
    }

    private static ServiceRegistryManager boundManager(Binding binding, ServiceRegistryConfig config, ServiceRegistryManager manager) {
        RegistryStartupProvider.registerShutdownHandler(manager);
        ServiceRegistry registry = manager.registry(binding);
        GlobalServiceRegistry.registry(registry);
        double maxRunLevel = config.maxRunLevel();
        ArrayList<Double> runLevels = new ArrayList<Double>(config.runLevels());
        Collections.sort(runLevels);
        ServiceRegistryManager.initializeRunLevels(registry, maxRunLevel, runLevels);
        return manager;
    }

    private static ServiceDescriptor<?> virtualDescriptor(ServiceRegistryConfig config, ServiceDiscovery discovery, ServiceDescriptor<?> descriptor) {
        TypeName serviceType = descriptor.serviceType();
        Optional<ServiceDescriptor> fromConfig = config.serviceDescriptors().stream().filter(registered -> registered.serviceType().equals((Object)serviceType)).findFirst();
        if (fromConfig.isPresent()) {
            return fromConfig.get();
        }
        return discovery.allMetadata().stream().filter(handler -> ServiceRegistryManager.contains(handler.contracts(), serviceType)).map(DescriptorHandler::descriptor).filter(desc -> desc.serviceType().equals((Object)serviceType)).findFirst().map(it -> it).orElse(descriptor);
    }

    private static boolean contains(Set<ResolvedType> contracts, TypeName type) {
        return contracts.stream().anyMatch(it -> it.type().equals((Object)type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRegistry registry(Binding binding) {
        ReentrantReadWriteLock.ReadLock readLock = this.lifecycleLock.readLock();
        try {
            readLock.lock();
            if (this.registry != null) {
                CoreServiceRegistry coreServiceRegistry = this.registry;
                return coreServiceRegistry;
            }
        }
        finally {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.lifecycleLock.writeLock();
        try {
            writeLock.lock();
            if (this.registry != null) {
                CoreServiceRegistry coreServiceRegistry = this.registry;
                return coreServiceRegistry;
            }
            Set<ServiceDescriptor<?>> descriptors = Collections.newSetFromMap(new IdentityHashMap());
            HashMap<TypeName, ServiceInfo> scopeHandlers = new HashMap<TypeName, ServiceInfo>();
            IdentityHashMap<ServiceInfo, Object> explicitInstances = new IdentityHashMap<ServiceInfo, Object>();
            HashMap<TypeName, ServiceInfo> servicesByType = new HashMap<TypeName, ServiceInfo>();
            HashMap<ResolvedType, Set<ServiceInfo>> servicesByContract = new HashMap<ResolvedType, Set<ServiceInfo>>();
            HashMap<TypeName, Set<ServiceInfo>> qualifiedProvidersByQualifier = new HashMap<TypeName, Set<ServiceInfo>>();
            HashMap<TypedQualifiedProviderKey, Set<ServiceInfo>> typedQualifiedProviders = new HashMap<TypedQualifiedProviderKey, Set<ServiceInfo>>();
            this.config.serviceInstances().forEach((desc, instance) -> {
                ServiceDescriptor<?> descriptor = desc;
                if (descriptor instanceof VirtualDescriptor) {
                    descriptor = ServiceRegistryManager.virtualDescriptor(this.config, this.discovery, descriptor);
                }
                descriptors.add(descriptor);
                this.bind(scopeHandlers, servicesByType, servicesByContract, qualifiedProvidersByQualifier, typedQualifiedProviders, descriptor);
                explicitInstances.putIfAbsent(descriptor, instance);
            });
            for (ServiceDescriptor<?> descriptor2 : this.config.serviceDescriptors()) {
                descriptors.add(descriptor2);
                this.bind(scopeHandlers, servicesByType, servicesByContract, qualifiedProvidersByQualifier, typedQualifiedProviders, descriptor2);
            }
            for (DescriptorHandler descriptorMeta : this.discovery.allMetadata()) {
                ServiceDescriptor<?> descriptor3 = descriptorMeta.descriptor();
                descriptors.add(descriptor3);
                this.bind(scopeHandlers, servicesByType, servicesByContract, qualifiedProvidersByQualifier, typedQualifiedProviders, descriptor3);
            }
            Scopes__ServiceDescriptor<Scopes> scopesDescriptor = Scopes__ServiceDescriptor.INSTANCE;
            ServiceRegistry__ServiceDescriptor<ServiceRegistry> registryDescriptor = ServiceRegistry__ServiceDescriptor.INSTANCE;
            descriptors.add(scopesDescriptor);
            descriptors.add(registryDescriptor);
            this.bind(scopeHandlers, servicesByType, servicesByContract, qualifiedProvidersByQualifier, typedQualifiedProviders, registryDescriptor);
            InterceptionMetadata__ServiceDescriptor<InterceptionMetadata> interceptDescriptor = InterceptionMetadata__ServiceDescriptor.INSTANCE;
            descriptors.add(interceptDescriptor);
            this.bind(scopeHandlers, servicesByType, servicesByContract, qualifiedProvidersByQualifier, typedQualifiedProviders, interceptDescriptor);
            HashMap<ResolvedType, AtomicBoolean> accessedContracts = new HashMap<ResolvedType, AtomicBoolean>();
            descriptors.stream().forEach(descriptor -> {
                accessedContracts.put(ResolvedType.create((TypeName)descriptor.serviceType()), new AtomicBoolean());
                descriptor.contracts().forEach(contract -> accessedContracts.put((ResolvedType)contract, new AtomicBoolean()));
            });
            this.registry = new CoreServiceRegistry(this.config, descriptors, scopeHandlers, explicitInstances, servicesByType, servicesByContract, qualifiedProvidersByQualifier, typedQualifiedProviders, accessedContracts);
            if (this.config.useBinding()) {
                binding.binding(new ApplicationPlanBinder(binding, this.registry));
            }
            this.registry.ensureInjectionPlans();
            CoreServiceRegistry coreServiceRegistry = this.registry;
            return coreServiceRegistry;
        }
        finally {
            writeLock.unlock();
        }
    }

    private void bind(Map<TypeName, ServiceInfo> scopeHandlers, Map<TypeName, ServiceInfo> servicesByType, Map<ResolvedType, Set<ServiceInfo>> servicesByContract, Map<TypeName, Set<ServiceInfo>> qualifiedProvidersByQualifier, Map<TypedQualifiedProviderKey, Set<ServiceInfo>> typedQualifiedProviders, ServiceDescriptor<?> descriptor) {
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            if (descriptor instanceof ServiceLoader__ServiceDescriptor) {
                ServiceLoader__ServiceDescriptor sl = (ServiceLoader__ServiceDescriptor)descriptor;
                LOGGER.log(System.Logger.Level.TRACE, "Binding service loader descriptor: " + String.valueOf(sl) + ")");
            } else {
                LOGGER.log(System.Logger.Level.TRACE, "Binding service descriptor: " + descriptor.descriptorType().fqName());
            }
        }
        servicesByType.putIfAbsent(descriptor.serviceType(), descriptor);
        servicesByContract.computeIfAbsent(ResolvedType.create((TypeName)descriptor.serviceType()), it -> new TreeSet<ServiceInfo>(SERVICE_INFO_COMPARATOR)).add(descriptor);
        Set<ResolvedType> contracts = descriptor.contracts();
        for (ResolvedType contract : contracts) {
            servicesByContract.computeIfAbsent(contract, it -> new TreeSet<ServiceInfo>(SERVICE_INFO_COMPARATOR)).add(descriptor);
        }
        if (ServiceRegistryManager.contains(contracts, Service.ScopeHandler.TYPE)) {
            if (!Service.Singleton.TYPE.equals((Object)descriptor.scope())) {
                throw new ServiceRegistryException("Services that provide ScopeHandler contract MUST be in Singleton scope, but " + descriptor.serviceType().fqName() + " is in " + descriptor.scope().fqName() + " scope.");
            }
            if (descriptor instanceof GeneratedService.ScopeHandlerDescriptor) {
                GeneratedService.ScopeHandlerDescriptor shd = (GeneratedService.ScopeHandlerDescriptor)((Object)descriptor);
                scopeHandlers.putIfAbsent(shd.handledScope(), descriptor);
            } else {
                throw new ServiceRegistryException("Service descriptors of services that implement ScopeHandler MUST implement ScopeHandlerDescriptor. Service " + descriptor.descriptorType().fqName() + " does not.");
            }
        }
        if (descriptor.factoryType() == FactoryType.QUALIFIED) {
            if (descriptor instanceof GeneratedService.QualifiedFactoryDescriptor) {
                GeneratedService.QualifiedFactoryDescriptor qpd = (GeneratedService.QualifiedFactoryDescriptor)((Object)descriptor);
                TypeName qualifierType = qpd.qualifierType();
                if (ServiceRegistryManager.contains(contracts, TypeNames.OBJECT)) {
                    qualifiedProvidersByQualifier.computeIfAbsent(qualifierType, it -> new TreeSet<ServiceInfo>(SERVICE_INFO_COMPARATOR)).add(descriptor);
                } else {
                    Set realContracts = contracts.stream().map(ResolvedType::type).filter(Predicate.not(arg_0 -> ((TypeName)Service.QualifiedFactory.TYPE).equals(arg_0))).collect(Collectors.toSet());
                    for (TypeName realContract : realContracts) {
                        TypedQualifiedProviderKey key = new TypedQualifiedProviderKey(qualifierType, ResolvedType.create((TypeName)realContract));
                        typedQualifiedProviders.computeIfAbsent(key, it -> new TreeSet<ServiceInfo>(SERVICE_INFO_COMPARATOR)).add(descriptor);
                    }
                }
            } else {
                throw new ServiceRegistryException("Service descriptors of services that implement QualifiedProvider MUST implement QualifiedProviderDescriptor. Service " + descriptor.descriptorType().fqName() + " does not.");
            }
        }
        Set<ResolvedType> factoryContracts = descriptor.factoryContracts();
        for (ResolvedType factoryContract : factoryContracts) {
            if (contracts.contains(factoryContract)) continue;
            servicesByContract.computeIfAbsent(factoryContract, it -> new TreeSet<ServiceInfo>(SERVICE_INFO_COMPARATOR)).add(descriptor);
        }
    }

    private static class NoOpBinding
    extends EmptyBinding {
        protected NoOpBinding() {
            super("no-op");
        }
    }

    private static class ApplicationPlanBinder
    implements DependencyPlanBinder {
        private static final System.Logger LOGGER = System.getLogger(ApplicationPlanBinder.class.getName());
        private final Binding appInstance;
        private final CoreServiceRegistry registry;
        private final Bindings bindings;

        private ApplicationPlanBinder(Binding appInstance, CoreServiceRegistry registry) {
            this.appInstance = appInstance;
            this.registry = registry;
            this.bindings = registry.bindings();
        }

        @Override
        public DependencyPlanBinder.Binder service(ServiceInfo descriptor) {
            Bindings.ServiceBindingPlan serviceBindingPlan = this.bindings.bindingPlan(descriptor);
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "binding injection plan to " + descriptor.serviceType().fqName());
            }
            return new ServiceBinder(serviceBindingPlan);
        }

        @Override
        public void interceptors(ServiceInfo ... descriptors) {
            this.registry.interceptors(descriptors);
        }

        public String toString() {
            return "Service binder for application: " + this.appInstance.name();
        }

        private static class ServiceBinder
        implements DependencyPlanBinder.Binder {
            private final Bindings.ServiceBindingPlan serviceBindingPlan;

            ServiceBinder(Bindings.ServiceBindingPlan serviceBindingPlan) {
                this.serviceBindingPlan = serviceBindingPlan;
            }

            @Override
            public DependencyPlanBinder.Binder bind(Dependency dependency, ServiceInfo ... descriptor) {
                this.serviceBindingPlan.binding(dependency).bind(List.of(descriptor));
                return this;
            }
        }
    }

    record TypedQualifiedProviderKey(TypeName qualifier, ResolvedType contract) {
    }
}

