/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.roster;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.node.app.spi.migrate.HederaMigrationContext;
import com.hedera.node.app.spi.migrate.StartupNetworks;
import com.hedera.node.config.data.NetworkAdminConfig;
import com.hedera.node.internal.network.Network;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.roster.RosterUtils;
import org.hiero.consensus.roster.WritableRosterStore;

public interface RosterTransplantSchema {
    public static final Logger log = LogManager.getLogger(RosterTransplantSchema.class);

    default public boolean restart(@NonNull HederaMigrationContext ctx, @NonNull BiConsumer<Roster, Roster> onAdopt, @NonNull Function<WritableStates, WritableRosterStore> rosterStoreFactory) {
        Objects.requireNonNull(ctx);
        long roundNumber = ctx.roundNumber();
        StartupNetworks startupNetworks = ctx.startupNetworks();
        Optional overrideNetwork = startupNetworks.overrideNetworkFor(roundNumber, ctx.platformConfig());
        overrideNetwork.ifPresent(network -> {
            long activeRoundNumber = roundNumber + 1L;
            log.info("Adopting roster from override network in round {}", (Object)activeRoundNumber);
            WritableRosterStore rosterStore = (WritableRosterStore)rosterStoreFactory.apply(ctx.newStates());
            Roster outgoingRoster = Objects.requireNonNull(rosterStore.getActiveRoster());
            Roster overrideRoster = RosterUtils.rosterFrom((Network)network);
            NetworkAdminConfig networkAdminConfig = (NetworkAdminConfig)ctx.appConfig().getConfigData(NetworkAdminConfig.class);
            Roster roster = networkAdminConfig.preserveStateWeightsDuringOverride() ? RosterTransplantSchema.withExtantNodeWeights(overrideRoster, rosterStore.getActiveRoster()) : overrideRoster;
            rosterStore.putActiveRoster(roster, activeRoundNumber);
            rosterStore.updateTransplantInProgress(true);
            onAdopt.accept(outgoingRoster, roster);
            startupNetworks.setOverrideRound(roundNumber);
        });
        return overrideNetwork.isPresent();
    }

    private static Roster withExtantNodeWeights(@NonNull Roster to, @Nullable Roster from) {
        if (from == null) {
            return to;
        }
        Map<Long, Long> fromNodeWeights = from.rosterEntries().stream().collect(Collectors.toMap(RosterEntry::nodeId, RosterEntry::weight));
        return new Roster(to.rosterEntries().stream().map(entry -> entry.copyBuilder().weight(fromNodeWeights.getOrDefault(entry.nodeId(), entry.weight()).longValue()).build()).collect(Collectors.toList()));
    }
}

