/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.code;

import com.google.common.base.MoreObjects;
import com.google.common.base.Suppliers;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.code.CodeSection;
import org.hyperledger.besu.evm.internal.Words;

public class CodeV0
implements Code {
    public static final CodeV0 EMPTY_CODE = new CodeV0(Bytes.EMPTY);
    private final Bytes bytes;
    private final Supplier<Hash> codeHash;
    private long[] validJumpDestinations;
    private final CodeSection codeSectionZero;

    CodeV0(Bytes bytes) {
        this.bytes = bytes;
        this.codeHash = Suppliers.memoize(() -> Hash.hash((Bytes)bytes));
        this.codeSectionZero = new CodeSection(bytes.size(), 0, -1, -1, 0);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof CodeV0)) {
            return false;
        }
        CodeV0 that = (CodeV0)other;
        return this.bytes.equals((Object)that.bytes);
    }

    public int hashCode() {
        return this.bytes.hashCode();
    }

    @Override
    public int getSize() {
        return this.bytes.size();
    }

    @Override
    public int getDataSize() {
        return 0;
    }

    @Override
    public int getDeclaredDataSize() {
        return 0;
    }

    @Override
    public Bytes getBytes() {
        return this.bytes;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bytes", (Object)this.bytes).toString();
    }

    @Override
    public Hash getCodeHash() {
        return this.codeHash.get();
    }

    @Override
    public boolean isJumpDestInvalid(int jumpDestination) {
        long targetBit;
        long targetLong;
        if (jumpDestination < 0 || jumpDestination >= this.getSize()) {
            return true;
        }
        if (this.validJumpDestinations == null || this.validJumpDestinations.length == 0) {
            this.validJumpDestinations = this.calculateJumpDests();
        }
        return ((targetLong = this.validJumpDestinations[jumpDestination >>> 6]) & (targetBit = 1L << (jumpDestination & 0x3F))) == 0L;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public CodeSection getCodeSection(int section) {
        if (section == 0) {
            return this.codeSectionZero;
        }
        return null;
    }

    @Override
    public int getCodeSectionCount() {
        return 1;
    }

    @Override
    public int getEofVersion() {
        return 0;
    }

    @Override
    public int getSubcontainerCount() {
        return 0;
    }

    @Override
    public Optional<Code> getSubContainer(int index, Bytes auxData, EVM evm) {
        return Optional.empty();
    }

    @Override
    public Bytes getData(int offset, int length) {
        return Bytes.EMPTY;
    }

    long[] calculateJumpDests() {
        int size = this.getSize();
        long[] bitmap = new long[(size >> 6) + 1];
        byte[] rawCode = this.bytes.toArrayUnsafe();
        int length = rawCode.length;
        int i = 0;
        while (i < length) {
            long thisEntry = 0L;
            int entryPos = i >> 6;
            int max = Math.min(64, length - (entryPos << 6));
            for (int j = i & 0x3F; j < max; ++j) {
                byte operationNum = rawCode[i];
                if (operationNum >= 91) {
                    switch (operationNum) {
                        case 91: {
                            thisEntry |= 1L << j;
                            break;
                        }
                        case 96: {
                            ++i;
                            ++j;
                            break;
                        }
                        case 97: {
                            i += 2;
                            j += 2;
                            break;
                        }
                        case 98: {
                            i += 3;
                            j += 3;
                            break;
                        }
                        case 99: {
                            i += 4;
                            j += 4;
                            break;
                        }
                        case 100: {
                            i += 5;
                            j += 5;
                            break;
                        }
                        case 101: {
                            i += 6;
                            j += 6;
                            break;
                        }
                        case 102: {
                            i += 7;
                            j += 7;
                            break;
                        }
                        case 103: {
                            i += 8;
                            j += 8;
                            break;
                        }
                        case 104: {
                            i += 9;
                            j += 9;
                            break;
                        }
                        case 105: {
                            i += 10;
                            j += 10;
                            break;
                        }
                        case 106: {
                            i += 11;
                            j += 11;
                            break;
                        }
                        case 107: {
                            i += 12;
                            j += 12;
                            break;
                        }
                        case 108: {
                            i += 13;
                            j += 13;
                            break;
                        }
                        case 109: {
                            i += 14;
                            j += 14;
                            break;
                        }
                        case 110: {
                            i += 15;
                            j += 15;
                            break;
                        }
                        case 111: {
                            i += 16;
                            j += 16;
                            break;
                        }
                        case 112: {
                            i += 17;
                            j += 17;
                            break;
                        }
                        case 113: {
                            i += 18;
                            j += 18;
                            break;
                        }
                        case 114: {
                            i += 19;
                            j += 19;
                            break;
                        }
                        case 115: {
                            i += 20;
                            j += 20;
                            break;
                        }
                        case 116: {
                            i += 21;
                            j += 21;
                            break;
                        }
                        case 117: {
                            i += 22;
                            j += 22;
                            break;
                        }
                        case 118: {
                            i += 23;
                            j += 23;
                            break;
                        }
                        case 119: {
                            i += 24;
                            j += 24;
                            break;
                        }
                        case 120: {
                            i += 25;
                            j += 25;
                            break;
                        }
                        case 121: {
                            i += 26;
                            j += 26;
                            break;
                        }
                        case 122: {
                            i += 27;
                            j += 27;
                            break;
                        }
                        case 123: {
                            i += 28;
                            j += 28;
                            break;
                        }
                        case 124: {
                            i += 29;
                            j += 29;
                            break;
                        }
                        case 125: {
                            i += 30;
                            j += 30;
                            break;
                        }
                        case 126: {
                            i += 31;
                            j += 31;
                            break;
                        }
                        case 127: {
                            i += 32;
                            j += 32;
                            break;
                        }
                    }
                }
                ++i;
            }
            bitmap[entryPos] = thisEntry;
        }
        return bitmap;
    }

    @Override
    public int readBigEndianI16(int index) {
        return Words.readBigEndianI16(index, this.bytes.toArrayUnsafe());
    }

    @Override
    public int readBigEndianU16(int index) {
        return Words.readBigEndianU16(index, this.bytes.toArrayUnsafe());
    }

    @Override
    public int readU8(int index) {
        return this.bytes.toArrayUnsafe()[index] & 0xFF;
    }

    @Override
    public String prettyPrint() {
        return this.bytes.toHexString();
    }
}

