/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.crypto.Hash;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.precompile.AbstractPrecompiledContract;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BLAKE2BFPrecompileContract
extends AbstractPrecompiledContract {
    private static final Logger LOG = LoggerFactory.getLogger(BLAKE2BFPrecompileContract.class);

    public BLAKE2BFPrecompileContract(GasCalculator gasCalculator) {
        super("BLAKE2f", gasCalculator);
    }

    @Override
    public long gasRequirement(Bytes input) {
        if (input.size() != 213) {
            return 0L;
        }
        if ((input.get(212) & 0xFE) != 0) {
            return 0L;
        }
        byte[] roundsBytes = Arrays.copyOfRange(input.toArrayUnsafe(), 0, 4);
        BigInteger rounds = new BigInteger(1, roundsBytes);
        return rounds.longValueExact();
    }

    @Override
    @Nonnull
    public PrecompiledContract.PrecompileContractResult computePrecompile(Bytes input, @Nonnull MessageFrame messageFrame) {
        if (input.size() != 213) {
            LOG.trace("Incorrect input length.  Expected {} and got {}", (Object)213, (Object)input.size());
            return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
        }
        if ((input.get(212) & 0xFE) != 0) {
            LOG.trace("Incorrect finalization flag, expected 0 or 1 and got {}", (Object)input.get(212));
            return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
        }
        return PrecompiledContract.PrecompileContractResult.success(Hash.blake2bf((Bytes)input));
    }
}

