/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.fees.util;

import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hedera.node.app.spi.fees.Fees;
import com.hederahashgraph.api.proto.java.ExchangeRate;
import org.hiero.hapi.fees.FeeResult;

public class FeeUtils {
    private FeeUtils() {
    }

    public static Fees feeResultToFees(FeeResult feeResult, ExchangeRate rate) {
        return new Fees(FeeUtils.tinycentsToTinybars(feeResult.node, rate), FeeUtils.tinycentsToTinybars(feeResult.network, rate), FeeUtils.tinycentsToTinybars(feeResult.service, rate));
    }

    public static FeeResult feesToFeeResult(Fees fees, ExchangeRate rate) {
        FeeResult feeResult = new FeeResult();
        feeResult.addNodeFee(1L, FeeBuilder.getTinybarsFromTinyCents((ExchangeRate)rate, (long)fees.nodeFee()));
        feeResult.addNetworkFee(FeeBuilder.getTinybarsFromTinyCents((ExchangeRate)rate, (long)fees.networkFee()));
        feeResult.addServiceFee(1L, FeeBuilder.getTinybarsFromTinyCents((ExchangeRate)rate, (long)fees.serviceFee()));
        return feeResult;
    }

    public static long tinycentsToTinybars(long amount, ExchangeRate rate) {
        int hbarEquiv = rate.getHbarEquiv();
        if (CommonUtils.productWouldOverflow((long)amount, (long)hbarEquiv)) {
            return FeeBuilder.getTinybarsFromTinyCents((ExchangeRate)rate, (long)amount);
        }
        return amount * (long)hbarEquiv / (long)rate.getCentEquiv();
    }
}

