/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.buffers.Ascii;
import io.helidon.http.HeaderName;
import java.util.HashMap;
import java.util.Map;

enum HeaderNameEnum implements HeaderName
{
    ACCEPT("Accept"),
    ACCEPT_CHARSET("Accept-Charset"),
    ACCEPT_ENCODING("Accept-Encoding"),
    ACCEPT_LANGUAGE("Accept-Language"),
    ACCEPT_DATETIME("Accept-Datetime"),
    ACCESS_CONTROL_ALLOW_CREDENTIALS("Access-Control-Allow-Credentials"),
    ACCESS_CONTROL_ALLOW_HEADERS("Access-Control-Allow-Headers"),
    ACCESS_CONTROL_ALLOW_METHODS("Access-Control-Allow-Methods"),
    ACCESS_CONTROL_ALLOW_ORIGIN("Access-Control-Allow-Origin"),
    ACCESS_CONTROL_EXPOSE_HEADERS("Access-Control-Expose-Headers"),
    ACCESS_CONTROL_MAX_AGE("Access-Control-Max-Age"),
    ACCESS_CONTROL_REQUEST_HEADERS("Access-Control-Request-Headers"),
    ACCESS_CONTROL_REQUEST_METHOD("Access-Control-Request-Method"),
    AUTHORIZATION("Authorization"),
    COOKIE("Cookie"),
    EXPECT("Expect"),
    FORWARDED("Forwarded"),
    FROM("From"),
    HOST("Host"),
    IF_MATCH("If-Match"),
    IF_MODIFIED_SINCE("If-Modified-Since"),
    IF_NONE_MATCH("If-None-Match"),
    IF_RANGE("If-Range"),
    IF_UNMODIFIED_SINCE("If-Unmodified-Since"),
    MAX_FORWARDS("Max-Forwards"),
    ORIGIN("Origin"),
    PROXY_AUTHENTICATE("Proxy-Authenticate"),
    PROXY_AUTHORIZATION("Proxy-Authorization"),
    RANGE("Range"),
    REFERER("Referer"),
    REFRESH("Refresh"),
    TE("TE"),
    USER_AGENT("User-Agent"),
    VIA("Via"),
    ACCEPT_PATCH("Accept-Patch"),
    ACCEPT_RANGES("Accept-Ranges"),
    AGE("Age"),
    ALLOW("Allow"),
    ALT_SVC("Alt-Svc"),
    CACHE_CONTROL("Cache-Control"),
    CONNECTION("Connection"),
    CONTENT_DISPOSITION("Content-Disposition"),
    CONTENT_ENCODING("Content-Encoding"),
    CONTENT_LANGUAGE("Content-Language"),
    CONTENT_LENGTH("Content-Length"),
    CONTENT_LOCATION("aa"),
    CONTENT_RANGE("Content-Range"),
    CONTENT_TYPE("Content-Type"),
    DATE("Date"),
    ETAG("ETag"),
    EXPIRES("Expires"),
    LAST_MODIFIED("Last-Modified"),
    LINK("Link"),
    LOCATION("Location"),
    PRAGMA("Pragma"),
    PUBLIC_KEY_PINS("Public-Key-Pins"),
    RETRY_AFTER("Retry-After"),
    SERVER("Server"),
    SET_COOKIE("Set-Cookie"),
    SET_COOKIE2("Set-Cookie2"),
    STRICT_TRANSPORT_SECURITY("Strict-Transport-Security"),
    TRAILER("Trailer"),
    TRANSFER_ENCODING("Transfer-Encoding"),
    TSV("TSV"),
    UPGRADE("Upgrade"),
    VARY("Vary"),
    WARNING("Warning"),
    WWW_AUTHENTICATE("WWW-Authenticate"),
    X_CONTENT_TYPE_OPTIONS("X-Content-Type-Options"),
    X_FORWARDED_FOR("X-Forwarded-For"),
    X_FORWARDED_HOST("X-Forwarded-Host"),
    X_FORWARDED_PORT("X-Forwarded-Port"),
    X_FORWARDED_PREFIX("X-Forwarded-Prefix"),
    X_FORWARDED_PROTO("X-Forwarded-Proto"),
    X_HELIDON_CN("X-HELIDON-CN");

    private static final Map<String, HeaderName> BY_NAME;
    private static final Map<String, HeaderName> BY_CAP_NAME;
    private final String lowerCase;
    private final String http1Case;
    private final int index;

    private HeaderNameEnum(String http1Case) {
        this.http1Case = http1Case;
        this.lowerCase = this.http1Case.toLowerCase();
        this.index = this.ordinal();
    }

    static HeaderName byCapitalizedName(String name) {
        HeaderName found = BY_CAP_NAME.get(name);
        if (found == null) {
            return HeaderNameEnum.byName(Ascii.toLowerCase((String)name));
        }
        return found;
    }

    static HeaderName byName(String lowerCase) {
        return BY_NAME.get(lowerCase);
    }

    @Override
    public String lowerCase() {
        return this.lowerCase;
    }

    @Override
    public String defaultCase() {
        return this.http1Case;
    }

    @Override
    public int index() {
        return this.index;
    }

    static {
        HashMap<String, HeaderName> byName = new HashMap<String, HeaderName>();
        HashMap<String, HeaderName> byCapName = new HashMap<String, HeaderName>();
        for (HeaderNameEnum value : HeaderNameEnum.values()) {
            byName.put(value.lowerCase(), value);
            byCapName.put(value.defaultCase(), value);
        }
        BY_NAME = byName;
        BY_CAP_NAME = byCapName;
    }

    static class Strings {
        static final String ACCEPT_NAME = "Accept";
        static final String ACCEPT_CHARSET_NAME = "Accept-Charset";
        static final String ACCEPT_ENCODING_NAME = "Accept-Encoding";
        static final String ACCEPT_LANGUAGE_NAME = "Accept-Language";
        static final String ACCEPT_DATETIME_NAME = "Accept-Datetime";
        static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_NAME = "Access-Control-Allow-Credentials";
        static final String ACCESS_CONTROL_ALLOW_HEADERS_NAME = "Access-Control-Allow-Headers";
        static final String ACCESS_CONTROL_ALLOW_METHODS_NAME = "Access-Control-Allow-Methods";
        static final String ACCESS_CONTROL_ALLOW_ORIGIN_NAME = "Access-Control-Allow-Origin";
        static final String ACCESS_CONTROL_EXPOSE_HEADERS_NAME = "Access-Control-Expose-Headers";
        static final String ACCESS_CONTROL_MAX_AGE_NAME = "Access-Control-Max-Age";
        static final String ACCESS_CONTROL_REQUEST_HEADERS_NAME = "Access-Control-Request-Headers";
        static final String ACCESS_CONTROL_REQUEST_METHOD_NAME = "Access-Control-Request-Method";
        static final String AUTHORIZATION_NAME = "Authorization";
        static final String COOKIE_NAME = "Cookie";
        static final String EXPECT_NAME = "Expect";
        static final String FORWARDED_NAME = "Forwarded";
        static final String FROM_NAME = "From";
        static final String HOST_NAME = "Host";
        static final String IF_MATCH_NAME = "If-Match";
        static final String IF_MODIFIED_SINCE_NAME = "If-Modified-Since";
        static final String IF_NONE_MATCH_NAME = "If-None-Match";
        static final String IF_RANGE_NAME = "If-Range";
        static final String IF_UNMODIFIED_SINCE_NAME = "If-Unmodified-Since";
        static final String MAX_FORWARDS_NAME = "Max-Forwards";
        static final String ORIGIN_NAME = "Origin";
        static final String PROXY_AUTHENTICATE_NAME = "Proxy-Authenticate";
        static final String PROXY_AUTHORIZATION_NAME = "Proxy-Authorization";
        static final String RANGE_NAME = "Range";
        static final String REFERER_NAME = "Referer";
        static final String REFRESH_NAME = "Refresh";
        static final String TE_NAME = "TE";
        static final String USER_AGENT_NAME = "User-Agent";
        static final String VIA_NAME = "Via";
        static final String ACCEPT_PATCH_NAME = "Accept-Patch";
        static final String ACCEPT_RANGES_NAME = "Accept-Ranges";
        static final String AGE_NAME = "Age";
        static final String ALLOW_NAME = "Allow";
        static final String ALT_SVC_NAME = "Alt-Svc";
        static final String CACHE_CONTROL_NAME = "Cache-Control";
        static final String CONNECTION_NAME = "Connection";
        static final String CONTENT_DISPOSITION_NAME = "Content-Disposition";
        static final String CONTENT_ENCODING_NAME = "Content-Encoding";
        static final String CONTENT_LANGUAGE_NAME = "Content-Language";
        static final String CONTENT_LENGTH_NAME = "Content-Length";
        static final String CONTENT_LOCATION_NAME = "aa";
        static final String CONTENT_RANGE_NAME = "Content-Range";
        static final String CONTENT_TYPE_NAME = "Content-Type";
        static final String DATE_NAME = "Date";
        static final String ETAG_NAME = "ETag";
        static final String EXPIRES_NAME = "Expires";
        static final String LAST_MODIFIED_NAME = "Last-Modified";
        static final String LINK_NAME = "Link";
        static final String LOCATION_NAME = "Location";
        static final String PRAGMA_NAME = "Pragma";
        static final String PUBLIC_KEY_PINS_NAME = "Public-Key-Pins";
        static final String RETRY_AFTER_NAME = "Retry-After";
        static final String SERVER_NAME = "Server";
        static final String SET_COOKIE_NAME = "Set-Cookie";
        static final String SET_COOKIE2_NAME = "Set-Cookie2";
        static final String STRICT_TRANSPORT_SECURITY_NAME = "Strict-Transport-Security";
        static final String TRAILER_NAME = "Trailer";
        static final String TRANSFER_ENCODING_NAME = "Transfer-Encoding";
        static final String TSV_NAME = "TSV";
        static final String UPGRADE_NAME = "Upgrade";
        static final String VARY_NAME = "Vary";
        static final String WARNING_NAME = "Warning";
        static final String WWW_AUTHENTICATE_NAME = "WWW-Authenticate";
        static final String X_CONTENT_TYPE_OPTIONS_NAME = "X-Content-Type-Options";
        static final String X_FORWARDED_FOR_NAME = "X-Forwarded-For";
        static final String X_FORWARDED_HOST_NAME = "X-Forwarded-Host";
        static final String X_FORWARDED_PORT_NAME = "X-Forwarded-Port";
        static final String X_FORWARDED_PREFIX_NAME = "X-Forwarded-Prefix";
        static final String X_FORWARDED_PROTO_NAME = "X-Forwarded-Proto";
        static final String X_HELIDON_CN_NAME = "X-HELIDON-CN";

        private Strings() {
        }
    }
}

