/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.handlers;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.file.FileGetContentsQuery;
import com.hedera.hapi.node.file.FileGetContentsResponse;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.FileFeeBuilder;
import com.hedera.node.app.service.addressbook.ReadableNodeStore;
import com.hedera.node.app.service.file.FileMetadata;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.service.file.impl.base.FileQueryBase;
import com.hedera.node.app.service.file.impl.schemas.V0490FileSchema;
import com.hedera.node.app.service.file.impl.utils.FileServiceUtils;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hederahashgraph.api.proto.java.FeeData;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FileGetContentsHandler
extends FileQueryBase {
    private final FileFeeBuilder usageEstimator;
    private final V0490FileSchema genesisSchema;

    @Inject
    public FileGetContentsHandler(@NonNull FileFeeBuilder usageEstimator, @NonNull V0490FileSchema genesisSchema) {
        this.usageEstimator = Objects.requireNonNull(usageEstimator);
        this.genesisSchema = Objects.requireNonNull(genesisSchema);
    }

    @NonNull
    public QueryHeader extractHeader(@NonNull Query query) {
        Objects.requireNonNull(query);
        return query.fileGetContentsOrThrow().header();
    }

    @NonNull
    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        FileGetContentsResponse.Builder response = FileGetContentsResponse.newBuilder().header(header);
        return Response.newBuilder().fileGetContents(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Query query = context.query();
        FileGetContentsQuery op = query.fileGetContentsOrThrow();
        if (!op.hasFileID()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_FILE_ID);
        }
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext queryContext) {
        Query query = queryContext.query();
        ReadableFileStore fileStore = (ReadableFileStore)queryContext.createStore(ReadableFileStore.class);
        ReadableNodeStore nodeStore = (ReadableNodeStore)queryContext.createStore(ReadableNodeStore.class);
        FileGetContentsQuery op = query.fileGetContentsOrThrow();
        FileID fileId = op.fileIDOrElse(FileID.DEFAULT);
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        FileGetContentsResponse.FileContents fileContents = this.contentFile(fileId, fileStore, queryContext.configuration(), nodeStore);
        return queryContext.feeCalculator().legacyCalculate(sigValueObj -> this.usageGivenType(fileContents, CommonPbjConverters.fromPbjResponseType((ResponseType)responseType)));
    }

    @NonNull
    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        Query query = context.query();
        ReadableFileStore fileStore = (ReadableFileStore)context.createStore(ReadableFileStore.class);
        ReadableNodeStore nodeStore = (ReadableNodeStore)context.createStore(ReadableNodeStore.class);
        FileGetContentsQuery op = query.fileGetContentsOrThrow();
        FileGetContentsResponse.Builder responseBuilder = FileGetContentsResponse.newBuilder();
        FileID fileId = op.fileIDOrThrow();
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        responseBuilder.header(header);
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK && responseType != ResponseType.COST_ANSWER) {
            FileGetContentsResponse.FileContents content = this.contentFile(fileId, fileStore, context.configuration(), nodeStore);
            if (content == null) {
                responseBuilder.header(header.copyBuilder().nodeTransactionPrecheckCode(ResponseCodeEnum.INVALID_FILE_ID).build());
            } else {
                responseBuilder.fileContents(content);
            }
        }
        return Response.newBuilder().fileGetContents(responseBuilder).build();
    }

    @Nullable
    private FileGetContentsResponse.FileContents contentFile(@NonNull FileID fileID, @NonNull ReadableFileStore fileStore, @NonNull Configuration config, @NonNull ReadableNodeStore nodeStore) {
        FileMetadata meta = fileStore.getFileMetadata(fileID);
        if (meta == null) {
            if (FileServiceUtils.notGenesisCreation(fileID, config)) {
                return null;
            }
            Bytes genesisContent = this.genesisContentProviders(config, nodeStore).getOrDefault(fileID.fileNum(), ignore -> Bytes.EMPTY).apply(config);
            return new FileGetContentsResponse.FileContents(fileID, genesisContent);
        }
        FileGetContentsResponse.FileContents.Builder info = FileGetContentsResponse.FileContents.newBuilder();
        info.fileID(fileID);
        info.contents(meta.contents());
        return info.build();
    }

    private Map<Long, Function<Configuration, Bytes>> genesisContentProviders(@NonNull Configuration config, @NonNull ReadableNodeStore nodeStore) {
        FilesConfig filesConfig = (FilesConfig)config.getConfigData(FilesConfig.class);
        return Map.of(filesConfig.addressBook(), ignore -> this.genesisSchema.nodeStoreAddressBook(nodeStore), filesConfig.nodeDetails(), ignore -> this.genesisSchema.nodeStoreNodeDetails(nodeStore), filesConfig.feeSchedules(), this.genesisSchema::genesisFeeSchedules, filesConfig.simpleFeesSchedules(), this.genesisSchema::genesisSimpleFeesSchedules, filesConfig.exchangeRates(), this.genesisSchema::genesisExchangeRates, filesConfig.networkProperties(), this.genesisSchema::genesisNetworkProperties, filesConfig.hapiPermissions(), this.genesisSchema::genesisHapiPermissions, filesConfig.throttleDefinitions(), this.genesisSchema::genesisThrottleDefinitions);
    }

    private FeeData usageGivenType(FileGetContentsResponse.FileContents fileContents, com.hederahashgraph.api.proto.java.ResponseType type) {
        if (fileContents == null) {
            return FeeData.getDefaultInstance();
        }
        return this.usageEstimator.getFileContentQueryFeeMatrices(fileContents.contents().toByteArray().length, type);
    }
}

