/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class MStore8Operation
extends AbstractOperation {
    public MStore8Operation(GasCalculator gasCalculator) {
        super(83, "MSTORE8", 2, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long location = Words.clampedToLong(frame.popStackItem());
        Bytes value = frame.popStackItem();
        byte theByte = value.size() > 0 ? value.get(value.size() - 1) : (byte)0;
        long cost = this.gasCalculator().mStore8OperationGasCost(frame, location);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        frame.writeMemory(location, theByte, true);
        return new Operation.OperationResult(cost, null);
    }
}

