/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.OverflowException;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class SLoadOperation
extends AbstractOperation {
    private final long warmCost;
    private final long coldCost;
    private final Operation.OperationResult warmSuccess;
    private final Operation.OperationResult coldSuccess;

    public SLoadOperation(GasCalculator gasCalculator) {
        super(84, "SLOAD", 1, 1, gasCalculator);
        long baseCost = gasCalculator.getSloadOperationGasCost();
        this.warmCost = baseCost + gasCalculator.getWarmStorageReadCost();
        this.coldCost = baseCost + gasCalculator.getColdSloadCost();
        this.warmSuccess = new Operation.OperationResult(this.warmCost, null);
        this.coldSuccess = new Operation.OperationResult(this.coldCost, null);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        try {
            long cost;
            Account account = frame.getWorldUpdater().get(frame.getRecipientAddress());
            Address address = account.getAddress();
            UInt256 key = UInt256.fromBytes((Bytes)frame.popStackItem());
            boolean slotIsWarm = frame.warmUpStorage(address, (Bytes32)key);
            long l = cost = slotIsWarm ? this.warmCost : this.coldCost;
            if (frame.getRemainingGas() < cost) {
                return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
            }
            frame.pushStackItem((Bytes)account.getStorageValue(UInt256.fromBytes((Bytes)key)));
            return slotIsWarm ? this.warmSuccess : this.coldSuccess;
        }
        catch (UnderflowException ufe) {
            return new Operation.OperationResult(this.warmCost, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
        }
        catch (OverflowException ofe) {
            return new Operation.OperationResult(this.warmCost, ExceptionalHaltReason.TOO_MANY_STACK_ITEMS);
        }
    }
}

