/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.worldstate;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.collections.undo.UndoNavigableMap;
import org.hyperledger.besu.collections.undo.UndoScalar;
import org.hyperledger.besu.collections.undo.Undoable;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.ModificationNotAllowedException;
import org.hyperledger.besu.evm.account.AccountStorageEntry;
import org.hyperledger.besu.evm.account.MutableAccount;

public class JournaledAccount
implements MutableAccount,
Undoable {
    private final Address address;
    private final Hash addressHash;
    @Nullable
    private MutableAccount account;
    private long transactionBoundaryMark;
    private final UndoScalar<Long> nonce;
    private final UndoScalar<Wei> balance;
    private final UndoScalar<Bytes> code;
    private final UndoScalar<Hash> codeHash;
    private final UndoScalar<Boolean> deleted;
    private final UndoNavigableMap<UInt256, UInt256> updatedStorage;
    private boolean storageWasCleared = false;
    boolean immutable;

    JournaledAccount(Address address) {
        Preconditions.checkNotNull((Object)address);
        this.address = address;
        this.addressHash = this.address.addressHash();
        this.account = null;
        this.nonce = UndoScalar.of(0L);
        this.balance = UndoScalar.of(Wei.ZERO);
        this.code = UndoScalar.of(Bytes.EMPTY);
        this.codeHash = UndoScalar.of(Hash.EMPTY);
        this.deleted = UndoScalar.of(Boolean.FALSE);
        this.updatedStorage = UndoNavigableMap.of(new TreeMap());
        this.transactionBoundaryMark = this.mark();
    }

    public JournaledAccount(MutableAccount account) {
        Hash hash;
        Preconditions.checkNotNull((Object)account);
        this.address = account.getAddress();
        if (account instanceof JournaledAccount) {
            JournaledAccount journaledAccount = (JournaledAccount)account;
            hash = journaledAccount.addressHash;
        } else {
            hash = this.address.addressHash();
        }
        this.addressHash = hash;
        this.account = account;
        if (account instanceof JournaledAccount) {
            JournaledAccount that = (JournaledAccount)account;
            this.nonce = that.nonce;
            this.balance = that.balance;
            this.code = that.code;
            this.codeHash = that.codeHash;
            this.deleted = that.deleted;
            this.updatedStorage = that.updatedStorage;
        } else {
            this.nonce = UndoScalar.of(account.getNonce());
            this.balance = UndoScalar.of(account.getBalance());
            this.code = UndoScalar.of(account.getCode());
            this.codeHash = UndoScalar.of(account.getCodeHash());
            this.deleted = UndoScalar.of(Boolean.FALSE);
            this.updatedStorage = UndoNavigableMap.of(new TreeMap());
        }
        this.transactionBoundaryMark = this.mark();
    }

    public MutableAccount getWrappedAccount() {
        return this.account;
    }

    public void setWrappedAccount(MutableAccount account) {
        if (this.account != null) {
            throw new IllegalStateException("Already tracking a wrapped account");
        }
        this.account = account;
        this.storageWasCleared = false;
    }

    public boolean codeWasUpdated() {
        return this.code.lastUpdate() >= this.transactionBoundaryMark;
    }

    @Override
    public Map<UInt256, UInt256> getUpdatedStorage() {
        return this.updatedStorage;
    }

    @Override
    public void becomeImmutable() {
        this.immutable = true;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public Hash getAddressHash() {
        return this.addressHash;
    }

    @Override
    public long getNonce() {
        return this.nonce.get();
    }

    @Override
    public void setNonce(long value) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.nonce.set(value);
    }

    @Override
    public Wei getBalance() {
        return this.balance.get();
    }

    @Override
    public void setBalance(Wei value) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.balance.set(value);
    }

    @Override
    public Bytes getCode() {
        return this.code.get();
    }

    @Override
    public Hash getCodeHash() {
        return this.codeHash.get();
    }

    @Override
    public boolean hasCode() {
        return !this.code.get().isEmpty();
    }

    public void setDeleted(boolean accountDeleted) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.deleted.set(accountDeleted);
    }

    public Boolean getDeleted() {
        return this.deleted.get();
    }

    @Override
    public void setCode(Bytes code) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.code.set(code == null ? Bytes.EMPTY : code);
        this.codeHash.set(code == null ? Hash.EMPTY : Hash.hash((Bytes)code));
    }

    void markTransactionBoundary() {
        this.transactionBoundaryMark = this.mark();
    }

    @Override
    public UInt256 getStorageValue(UInt256 key) {
        UInt256 value = (UInt256)this.updatedStorage.get(key);
        if (value != null) {
            return value;
        }
        if (this.storageWasCleared) {
            return UInt256.ZERO;
        }
        return this.account == null ? UInt256.ZERO : this.account.getStorageValue(key);
    }

    @Override
    public UInt256 getOriginalStorageValue(UInt256 key) {
        return this.storageWasCleared || this.account == null ? UInt256.ZERO : this.account.getStorageValue(key);
    }

    @Override
    public NavigableMap<Bytes32, AccountStorageEntry> storageEntriesFrom(Bytes32 startKeyHash, int limit) {
        NavigableMap<Object, Object> entries = this.account != null ? this.account.storageEntriesFrom(startKeyHash, limit) : new TreeMap();
        this.updatedStorage.entrySet().stream().map(entry -> AccountStorageEntry.forKeyAndValue((UInt256)entry.getKey(), (UInt256)entry.getValue())).filter(entry -> entry.getKeyHash().compareTo((Bytes)startKeyHash) >= 0).forEach(entry -> entries.put(entry.getKeyHash(), entry));
        while (entries.size() > limit) {
            entries.remove(entries.lastKey());
        }
        return entries;
    }

    @Override
    public void setStorageValue(UInt256 key, UInt256 value) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.updatedStorage.put(key, value);
    }

    @Override
    public void clearStorage() {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.storageWasCleared = true;
        this.updatedStorage.clear();
    }

    @Override
    public boolean isStorageEmpty() {
        return this.updatedStorage.isEmpty() && (this.storageWasCleared || this.account == null || this.account.isStorageEmpty());
    }

    public boolean getStorageWasCleared() {
        return this.storageWasCleared;
    }

    public void setStorageWasCleared(boolean storageWasCleared) {
        if (this.immutable) {
            throw new ModificationNotAllowedException();
        }
        this.storageWasCleared = storageWasCleared;
    }

    public String toString() {
        String storage;
        String string = storage = this.updatedStorage.isEmpty() ? "[not updated]" : this.updatedStorage.toString();
        if (this.updatedStorage.isEmpty() && this.storageWasCleared) {
            storage = "[cleared]";
        }
        return String.format("%s -> {nonce: %s, balance:%s, code:%s, storage:%s }", this.address, this.nonce, this.balance, this.code.mark() >= this.transactionBoundaryMark ? "[not updated]" : this.code.get(), storage);
    }

    @Override
    public long lastUpdate() {
        return Math.max(this.nonce.lastUpdate(), Math.max(this.balance.lastUpdate(), Math.max(this.code.lastUpdate(), Math.max(this.codeHash.lastUpdate(), this.updatedStorage.lastUpdate()))));
    }

    @Override
    public void undo(long mark) {
        this.nonce.undo(mark);
        this.balance.undo(mark);
        this.code.undo(mark);
        this.codeHash.undo(mark);
        this.deleted.undo(mark);
        this.updatedStorage.undo(mark);
    }

    public void commit() {
        if (!(this.account instanceof JournaledAccount)) {
            if (this.nonce.updated()) {
                this.account.setNonce(this.nonce.get());
            }
            if (this.balance.updated()) {
                this.account.setBalance(this.balance.get());
            }
            if (this.code.updated()) {
                this.account.setCode(this.code.get() == null ? Bytes.EMPTY : this.code.get());
            }
            if (this.updatedStorage.updated()) {
                this.updatedStorage.forEach(this.account::setStorageValue);
            }
        }
    }
}

