/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.token;

import com.hedera.node.app.hapi.fees.usage.QueryUsage;
import com.hedera.node.app.hapi.fees.usage.token.entities.TokenEntitySizes;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.Query;
import java.util.Optional;

public class TokenGetInfoUsage
extends QueryUsage {
    private TokenGetInfoUsage(Query query) {
        super(query.getTokenGetInfo().getHeader().getResponseType());
        this.addTb(24L);
        this.addRb(TokenEntitySizes.TOKEN_ENTITY_SIZES.fixedBytesInTokenRepr());
    }

    public static TokenGetInfoUsage newEstimate(Query query) {
        return new TokenGetInfoUsage(query);
    }

    public TokenGetInfoUsage givenCurrentAdminKey(Optional<Key> adminKey) {
        adminKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::addRb);
        return this;
    }

    public TokenGetInfoUsage givenCurrentWipeKey(Optional<Key> wipeKey) {
        wipeKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::addRb);
        return this;
    }

    public TokenGetInfoUsage givenCurrentSupplyKey(Optional<Key> supplyKey) {
        supplyKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::addRb);
        return this;
    }

    public TokenGetInfoUsage givenCurrentFreezeKey(Optional<Key> freezeKey) {
        freezeKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::addRb);
        return this;
    }

    public TokenGetInfoUsage givenCurrentKycKey(Optional<Key> kycKey) {
        kycKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::addRb);
        return this;
    }

    public TokenGetInfoUsage givenCurrentPauseKey(Optional<Key> pauseKey) {
        pauseKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::addRb);
        return this;
    }

    public TokenGetInfoUsage givenCurrentMetadataKey(Optional<Key> metadataKey) {
        metadataKey.map(FeeBuilder::getAccountKeyStorageSize).ifPresent(this::addRb);
        return this;
    }

    public TokenGetInfoUsage givenCurrentMemo(String memo) {
        this.addRb(memo.length());
        return this;
    }

    public TokenGetInfoUsage givenCurrentName(String name) {
        this.addRb(name.length());
        return this;
    }

    public TokenGetInfoUsage givenCurrentSymbol(String symbol) {
        this.addRb(symbol.length());
        return this;
    }

    public TokenGetInfoUsage givenCurrentlyUsingAutoRenewAccount() {
        this.addRb(24L);
        return this;
    }

    public TokenGetInfoUsage givenCurrentMetadata(String metadata) {
        this.addRb(metadata.length());
        return this;
    }
}

