/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.sysfiles;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ParsingUtils {
    public static <T, A, B> T fromTwoPartDelimited(String literal, String delimiter, BiConsumer<A, B> validator, Function<String, A> aParser, Function<String, B> bParser, BiFunction<A, B, T> finisher) {
        int splitIndex = literal.indexOf(delimiter);
        if (splitIndex == -1) {
            throw new IllegalArgumentException("Missing '" + delimiter + "' in literal '" + literal + "'");
        }
        int delimLen = delimiter.length();
        A a = aParser.apply(literal.substring(0, splitIndex));
        B b = bParser.apply(literal.substring(splitIndex + delimLen));
        validator.accept(a, b);
        return finisher.apply(a, b);
    }

    private ParsingUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }
}

