/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2Frame;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameType;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Settings;

public final class Http2DataFrame
implements Http2Frame<Http2Flag.DataFlags> {
    private final BufferData bufferData;

    private Http2DataFrame(BufferData bufferData) {
        this.bufferData = bufferData;
    }

    public static Http2DataFrame create(BufferData bufferData) {
        return new Http2DataFrame(bufferData);
    }

    @Override
    public Http2FrameData toFrameData(Http2Settings settings, int streamId, Http2Flag.DataFlags flags) {
        Http2FrameHeader header = Http2FrameHeader.create(this.bufferData.available(), Http2FrameTypes.DATA, flags, streamId);
        return new Http2FrameData(header, this.bufferData);
    }

    @Override
    public String name() {
        return Http2FrameType.DATA.name();
    }

    @Override
    public Http2FrameType frameType() {
        return Http2FrameType.DATA;
    }

    @Override
    public Http2FrameTypes<Http2Flag.DataFlags> frameTypes() {
        return Http2FrameTypes.DATA;
    }
}

