/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.schemas;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.blockrecords.BlockInfo;
import com.hedera.hapi.node.state.blockrecords.RunningHashes;
import com.hedera.hapi.node.state.blockstream.BlockStreamInfo;
import com.hedera.hapi.platform.state.SingletonType;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.blocks.impl.BlockImplUtils;
import com.hedera.node.app.records.impl.BlockRecordInfoUtils;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class V0560BlockStreamSchema
extends Schema<SemanticVersion> {
    private static final BlockStreamInfo GENESIS_INFO = BlockStreamInfo.newBuilder().blockNumber(-1L).build();
    private static final String SHARED_BLOCK_RECORD_INFO = "SHARED_BLOCK_RECORD_INFO";
    private static final String SHARED_RUNNING_HASHES = "SHARED_RUNNING_HASHES";
    public static final String BLOCK_STREAM_INFO_KEY = "BLOCK_STREAM_INFO";
    public static final int BLOCK_STREAM_INFO_STATE_ID = SingletonType.BLOCKSTREAMSERVICE_I_BLOCK_STREAM_INFO.protoOrdinal();
    public static final String BLOCK_STREAM_INFO_STATE_LABEL = StateMetadata.computeLabel((String)"BlockStreamService", (String)"BLOCK_STREAM_INFO");
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(56).patch(0).build();
    private final Consumer<Bytes> migratedBlockHashConsumer;

    public V0560BlockStreamSchema(@NonNull Consumer<Bytes> migratedBlockHashConsumer) {
        super((Object)VERSION, HapiUtils.SEMANTIC_VERSION_COMPARATOR);
        this.migratedBlockHashConsumer = Objects.requireNonNull(migratedBlockHashConsumer);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate(@NonNull Configuration config) {
        return Set.of(StateDefinition.singleton((int)BLOCK_STREAM_INFO_STATE_ID, (String)BLOCK_STREAM_INFO_KEY, (Codec)BlockStreamInfo.PROTOBUF));
    }

    public void restart(@NonNull MigrationContext<SemanticVersion> ctx) {
        Objects.requireNonNull(ctx);
        WritableSingletonState state = ctx.newStates().getSingleton(BLOCK_STREAM_INFO_STATE_ID);
        if (ctx.isGenesis()) {
            state.put((Object)GENESIS_INFO);
        } else {
            Object blockStreamInfo = state.get();
            if (blockStreamInfo == null) {
                BlockInfo blockInfo = (BlockInfo)Objects.requireNonNull(ctx.sharedValues().get(SHARED_BLOCK_RECORD_INFO));
                RunningHashes runningHashes = (RunningHashes)Objects.requireNonNull(ctx.sharedValues().get(SHARED_RUNNING_HASHES));
                Bytes lastBlockHash = Objects.requireNonNull(BlockRecordInfoUtils.blockHashByBlockNumber(blockInfo, blockInfo.lastBlockNumber()));
                this.migratedBlockHashConsumer.accept(lastBlockHash);
                Bytes trailingBlockHashes = blockInfo.blockHashes().slice(lastBlockHash.length(), blockInfo.blockHashes().length() - lastBlockHash.length());
                state.put((Object)BlockStreamInfo.newBuilder().blockTime(blockInfo.firstConsTimeOfLastBlock()).blockNumber(blockInfo.lastBlockNumber()).trailingBlockHashes(trailingBlockHashes).trailingOutputHashes(this.appendedHashes(runningHashes)).blockEndTime(blockInfo.consTimeOfLastHandledTxn()).postUpgradeWorkDone(false).creationSoftwareVersion((SemanticVersion)ctx.previousVersion()).lastIntervalProcessTime(blockInfo.consTimeOfLastHandledTxn()).lastHandleTime(blockInfo.consTimeOfLastHandledTxn()).build());
            }
        }
    }

    private Bytes appendedHashes(RunningHashes runningHashes) {
        Bytes hashes = Bytes.EMPTY;
        hashes = BlockImplUtils.appendHash(runningHashes.nMinus3RunningHash(), hashes, 4);
        hashes = BlockImplUtils.appendHash(runningHashes.nMinus2RunningHash(), hashes, 4);
        hashes = BlockImplUtils.appendHash(runningHashes.nMinus1RunningHash(), hashes, 4);
        return BlockImplUtils.appendHash(runningHashes.runningHash(), hashes, 4);
    }
}

