/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints.handlers;

import com.hedera.hapi.services.auxiliary.hints.CrsPublicationTransactionBody;
import com.hedera.node.app.hints.WritableHintsStore;
import com.hedera.node.app.hints.impl.HintsControllers;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CrsPublicationHandler
implements TransactionHandler {
    private final HintsControllers controllers;

    @Inject
    public CrsPublicationHandler(HintsControllers controllers) {
        this.controllers = Objects.requireNonNull(controllers);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        CrsPublicationTransactionBody op = context.body().crsPublicationOrThrow();
        WritableHintsStore hintsStore = (WritableHintsStore)context.storeFactory().writableStore(WritableHintsStore.class);
        long creatorId = context.creatorInfo().nodeId();
        this.controllers.getAnyInProgress().ifPresent(controller -> {
            if (hintsStore.getCrsState().hasNextContributingNodeId() && creatorId == hintsStore.getCrsState().nextContributingNodeIdOrThrow()) {
                hintsStore.addCrsPublication(creatorId, op);
                controller.addCrsPublication(op, context.consensusNow(), hintsStore, creatorId);
            }
        });
    }
}

