/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.builder;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.time.Time;
import com.swirlds.common.io.utility.NoOpRecycleBin;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.common.metrics.event.EventPipelineTracker;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.crypto.KeysAndCertsGenerator;
import com.swirlds.platform.gossip.NoOpIntakeEventCounter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.hiero.consensus.crypto.SigningSchema;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.event.creator.EventCreatorModule;
import org.hiero.consensus.event.intake.EventIntakeModule;
import org.hiero.consensus.metrics.noop.NoOpMetrics;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterHistory;
import org.hiero.consensus.transaction.TransactionLimits;

public class ConsensusModuleBuilder {
    private ConsensusModuleBuilder() {
    }

    public static EventCreatorModule createEventCreatorModule() {
        return ServiceLoader.load(EventCreatorModule.class).findFirst().orElseThrow(() -> new IllegalStateException("No EventCreatorModule implementation found!"));
    }

    public static EventCreatorModule createNoOpEventCreatorModule(@NonNull WiringModel model, @NonNull Configuration configuration) {
        KeysAndCerts keysAndCerts;
        NoOpMetrics metrics = new NoOpMetrics();
        Time time = Time.getCurrent();
        NodeId selfId = NodeId.FIRST_NODE_ID;
        SecureRandom random = new SecureRandom();
        try {
            keysAndCerts = KeysAndCertsGenerator.generate(selfId, SigningSchema.ED25519, random, random);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception thrown while creating dummy KeysAndCerts", e);
        }
        RosterEntry rosterEntry = new RosterEntry(selfId.id(), 0L, Bytes.EMPTY, List.of());
        Roster roster = new Roster(List.of(rosterEntry));
        EventCreatorModule eventCreatorModule = ConsensusModuleBuilder.createEventCreatorModule();
        eventCreatorModule.initialize(model, configuration, (Metrics)metrics, time, random, keysAndCerts, roster, selfId, List::of, () -> false);
        return eventCreatorModule;
    }

    public static EventIntakeModule createEventIntakeModule() {
        return ServiceLoader.load(EventIntakeModule.class).findFirst().orElseThrow(() -> new IllegalStateException("No EventIntakeModule implementation found!"));
    }

    public static EventIntakeModule createNoOpEventIntakeModule(@NonNull WiringModel model, @NonNull Configuration configuration) {
        NoOpMetrics metrics = new NoOpMetrics();
        Time time = Time.getCurrent();
        NodeId selfId = NodeId.FIRST_NODE_ID;
        RosterEntry rosterEntry = new RosterEntry(selfId.id(), 0L, Bytes.EMPTY, List.of());
        Roster roster = new Roster(List.of(rosterEntry));
        RosterHistory rosterHistory = new RosterHistory(List.of(new RoundRosterPair(0L, Bytes.EMPTY)), Map.of(Bytes.EMPTY, roster));
        NoOpIntakeEventCounter intakeEventCounter = new NoOpIntakeEventCounter();
        TransactionLimits transactionLimits = new TransactionLimits(0, 0);
        NoOpRecycleBin recycleBin = new NoOpRecycleBin();
        long startingRound = 0L;
        EventPipelineTracker eventPipelineTracker = null;
        EventIntakeModule eventIntakeModule = ConsensusModuleBuilder.createEventIntakeModule();
        eventIntakeModule.initialize(model, configuration, (Metrics)metrics, time, rosterHistory, selfId, (IntakeEventCounter)intakeEventCounter, transactionLimits, (RecycleBin)recycleBin, 0L, eventPipelineTracker);
        return eventIntakeModule;
    }
}

