/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.protocol;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gossip.GossipController;
import com.swirlds.platform.gossip.permits.SyncPermitProvider;
import com.swirlds.platform.gossip.shadowgraph.AbstractShadowgraphSynchronizer;
import com.swirlds.platform.gossip.sync.config.SyncConfig;
import com.swirlds.platform.network.protocol.Protocol;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.event.IntakeEventCounter;

public abstract class AbstractSyncProtocol<T extends AbstractShadowgraphSynchronizer>
implements Protocol,
GossipController {
    private static final Logger logger = LogManager.getLogger(AbstractSyncProtocol.class);
    protected final SyncConfig syncConfig;
    private volatile boolean started;
    protected final T synchronizer;
    protected final SyncPermitProvider permitProvider;
    protected final AtomicBoolean gossipHalted = new AtomicBoolean(false);
    protected final IntakeEventCounter intakeEventCounter;

    protected AbstractSyncProtocol(@NonNull T synchronizer, @NonNull PlatformContext platformContext, int rosterSize, IntakeEventCounter intakeEventCounter) {
        this.synchronizer = synchronizer;
        this.intakeEventCounter = Objects.requireNonNull(intakeEventCounter);
        this.syncConfig = (SyncConfig)platformContext.getConfiguration().getConfigData(SyncConfig.class);
        int permitCount = this.syncConfig.onePermitPerPeer() ? rosterSize - 1 : this.syncConfig.syncProtocolPermitCount();
        this.permitProvider = new SyncPermitProvider(platformContext, permitCount);
    }

    public void adjustTotalPermits(int permitsDifference) {
        this.permitProvider.adjustTotalPermits(permitsDifference);
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("Gossip already started");
        }
        this.started = true;
        ((AbstractShadowgraphSynchronizer)this.synchronizer).start();
    }

    public void stop() {
        if (!this.started) {
            throw new IllegalStateException("Gossip not started");
        }
        logger.info(LogMarker.FREEZE.getMarker(), "Gossip frozen, reason: stopping gossip");
        this.gossipHalted.set(true);
        this.permitProvider.waitForAllPermitsToBeReleased();
        ((AbstractShadowgraphSynchronizer)this.synchronizer).stop();
    }

    @Override
    public void pause() {
        if (!this.started) {
            throw new IllegalStateException("Gossip not started");
        }
        this.gossipHalted.set(true);
        this.permitProvider.waitForAllPermitsToBeReleased();
    }

    @Override
    public void resume() {
        if (!this.started) {
            throw new IllegalStateException("Gossip not started");
        }
        this.intakeEventCounter.reset();
        this.gossipHalted.set(false);
        this.permitProvider.revokeAll();
    }

    public void reportUnhealthyDuration(@NonNull Duration duration) {
        this.permitProvider.reportUnhealthyDuration(duration);
    }

    public void clear() {
        ((AbstractShadowgraphSynchronizer)this.synchronizer).clear();
    }
}

