/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.balanceof;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AbstractRevertibleTokenViewCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.balanceof.BalanceOfTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Objects;

public class BalanceOfCall
extends AbstractRevertibleTokenViewCall {
    private final Address owner;

    public BalanceOfCall(@NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull SystemContractGasCalculator gasCalculator, @Nullable Token token, @NonNull Address owner) {
        super(gasCalculator, enhancement, token);
        this.owner = Objects.requireNonNull(owner);
    }

    @Override
    @NonNull
    protected Call.PricedResult resultOfViewingToken(@NonNull Token token) {
        long ownerNum = ConversionUtils.accountNumberForEvmReference(this.owner, this.nativeOperations());
        if (ownerNum < 0L) {
            return Call.PricedResult.gasOnly(FullResult.revertResult(ResponseCodeEnum.INVALID_ACCOUNT_ID, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.INVALID_ACCOUNT_ID, true);
        }
        long tokenNum = token.tokenIdOrThrow().tokenNum();
        TokenRelation relation = this.nativeOperations().getTokenRelation(this.nativeOperations().entityIdFactory().newAccountId(ownerNum), this.nativeOperations().entityIdFactory().newTokenId(tokenNum));
        long balance = relation == null ? 0L : relation.balance();
        ByteBuffer output = BalanceOfTranslator.BALANCE_OF.getOutputs().encode((Object)Tuple.singleton((Object)BigInteger.valueOf(balance)));
        return Call.PricedResult.gasOnly(FullResult.successResult(output, this.gasCalculator.viewGasRequirement()), ResponseCodeEnum.SUCCESS, true);
    }
}

