/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.setapproval;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.LogBuilder;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.setapproval.SetApprovalForAllTranslator;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.log.Log;

public class SetApprovalForAllCall
extends AbstractCall {
    private static final Bytes APPROVAL_FOR_ALL_EVENT = Bytes.fromHexString((CharSequence)"17307eab39ab6107e8899845ad3d59bd9653f200f220920489ca2b5937696c31");
    private final VerificationStrategy verificationStrategy;
    private final TransactionBody transactionBody;
    private final AccountID sender;
    private final DispatchGasCalculator dispatchGasCalculator;
    private final Address token;
    private final Address spender;
    private final boolean approved;

    public SetApprovalForAllCall(@NonNull HtsCallAttempt attempt, @NonNull TransactionBody transactionBody, @NonNull DispatchGasCalculator gasCalculator, boolean isERC) {
        super(attempt.systemContractGasCalculator(), attempt.enhancement(), false);
        this.transactionBody = transactionBody;
        this.dispatchGasCalculator = gasCalculator;
        this.verificationStrategy = attempt.defaultVerificationStrategy();
        this.sender = attempt.addressIdConverter().convertSender(attempt.senderAddress());
        if (isERC) {
            Tuple call = SetApprovalForAllTranslator.ERC721_SET_APPROVAL_FOR_ALL.decodeCall(attempt.inputBytes());
            this.token = ConversionUtils.asLongZeroAddress(attempt.redirectTokenId().tokenNum());
            this.spender = ConversionUtils.fromHeadlongAddress((com.esaulpaugh.headlong.abi.Address)call.get(0));
            this.approved = (Boolean)call.get(1);
        } else {
            Tuple call = SetApprovalForAllTranslator.SET_APPROVAL_FOR_ALL.decodeCall(attempt.inputBytes());
            this.token = ConversionUtils.fromHeadlongAddress((com.esaulpaugh.headlong.abi.Address)call.get(0));
            this.spender = ConversionUtils.fromHeadlongAddress((com.esaulpaugh.headlong.abi.Address)call.get(1));
            this.approved = (Boolean)call.get(2);
        }
    }

    @Override
    @NonNull
    public Call.PricedResult execute() {
        ContractCallStreamBuilder recordBuilder = this.systemContractOperations().dispatch(this.transactionBody, this.verificationStrategy, this.sender, ContractCallStreamBuilder.class);
        long gasRequirement = this.dispatchGasCalculator.gasRequirement(this.transactionBody, this.gasCalculator, this.enhancement, this.sender);
        ResponseCodeEnum status = recordBuilder.status();
        if (status != ResponseCodeEnum.SUCCESS) {
            if (status.equals((Object)ResponseCodeEnum.INVALID_ALLOWANCE_SPENDER_ID)) {
                return this.completionWith(ResponseCodeEnum.INVALID_ALLOWANCE_SPENDER_ID, gasRequirement);
            }
            if (status.equals((Object)ResponseCodeEnum.INVALID_TOKEN_ID)) {
                return this.completionWith(ResponseCodeEnum.INVALID_TOKEN_ID, gasRequirement);
            }
            return this.reversionWith(gasRequirement, recordBuilder);
        }
        return this.completionWith(gasRequirement, recordBuilder, ReturnTypes.encodedRc(ReturnTypes.standardized(status)));
    }

    @Override
    @NonNull
    public Call.PricedResult execute(MessageFrame frame) {
        Call.PricedResult result = this.execute();
        if (result.responseCode() == ResponseCodeEnum.SUCCESS) {
            frame.addLog(this.getLogForSetApprovalForAll(this.token));
        }
        return result;
    }

    private Log getLogForSetApprovalForAll(@NonNull Address logger) {
        return LogBuilder.logBuilder().forLogger(logger).forEventSignature(APPROVAL_FOR_ALL_EVENT).forIndexedArgument(ConversionUtils.asLongZeroAddress(this.sender.accountNumOrThrow())).forIndexedArgument(this.spender).forDataItem(this.approved).build();
    }
}

