/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.contract.EvmTransactionResult;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AddressIdConverter;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.ClassicTransfersCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.Erc20TransfersTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.SpecialRewardReceivers;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.TransferEventLoggingUtils;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class Erc20TransfersCall
extends AbstractCall {
    private final long amount;
    @Nullable
    private final Address from;
    private final Address to;
    @Nullable
    private final TokenID tokenId;
    private final VerificationStrategy verificationStrategy;
    private final AccountID senderId;
    private final AddressIdConverter addressIdConverter;
    private final boolean requiresApproval;
    private final SpecialRewardReceivers specialRewardReceivers;

    public Erc20TransfersCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, long amount, @Nullable Address from, @NonNull Address to, @Nullable TokenID tokenId, @NonNull VerificationStrategy verificationStrategy, @NonNull AccountID senderId, @NonNull AddressIdConverter addressIdConverter, boolean requiresApproval, @NonNull SpecialRewardReceivers specialRewardReceivers) {
        super(gasCalculator, enhancement, false);
        this.amount = amount;
        this.from = from;
        this.to = Objects.requireNonNull(to);
        this.tokenId = tokenId;
        this.verificationStrategy = Objects.requireNonNull(verificationStrategy);
        this.senderId = Objects.requireNonNull(senderId);
        this.addressIdConverter = Objects.requireNonNull(addressIdConverter);
        this.requiresApproval = requiresApproval;
        this.specialRewardReceivers = Objects.requireNonNull(specialRewardReceivers);
    }

    @Override
    @NonNull
    public Call.PricedResult execute(@NonNull MessageFrame frame) {
        TransactionBody syntheticTransfer = this.syntheticTransferOrTransferFrom(this.senderId);
        long gasRequirement = ClassicTransfersCall.transferGasRequirement(syntheticTransfer, this.gasCalculator, this.enhancement, this.senderId);
        if (this.tokenId == null) {
            return this.reversionWith(ResponseCodeEnum.INVALID_TOKEN_ID, gasRequirement);
        }
        ContractCallStreamBuilder recordBuilder = this.systemContractOperations().dispatch(syntheticTransfer, this.verificationStrategy, this.senderId, ContractCallStreamBuilder.class);
        ResponseCodeEnum status = recordBuilder.status();
        if (status != ResponseCodeEnum.SUCCESS) {
            if (status == ResponseCodeEnum.NOT_SUPPORTED) {
                return this.haltWith(gasRequirement, recordBuilder);
            }
            return Call.PricedResult.gasOnly(FullResult.revertResult(recordBuilder, gasRequirement), status, false);
        }
        CryptoTransferTransactionBody op = syntheticTransfer.cryptoTransferOrThrow();
        for (TokenTransferList fungibleTransfers : op.tokenTransfers()) {
            TransferEventLoggingUtils.logSuccessfulFungibleTransfer(Objects.requireNonNull(this.tokenId), fungibleTransfers.transfers(), this.enhancement.nativeOperations().readableAccountStore(), frame);
        }
        this.specialRewardReceivers.addInFrame(frame, op, recordBuilder.getAssessedCustomFees());
        ByteBuffer encodedOutput = this.from == null ? Erc20TransfersTranslator.ERC_20_TRANSFER.getOutputs().encode((Object)Tuple.singleton((Object)true)) : Erc20TransfersTranslator.ERC_20_TRANSFER_FROM.getOutputs().encode((Object)Tuple.singleton((Object)true));
        Bytes outputData = Bytes.wrap((byte[])encodedOutput.array());
        recordBuilder.contractCallResult(ContractFunctionResult.newBuilder().contractCallResult(outputData).build()).evmCallTransactionResult(EvmTransactionResult.newBuilder().resultData(outputData).build());
        return Call.PricedResult.gasOnly(FullResult.successResult(encodedOutput, gasRequirement, recordBuilder), status, false);
    }

    private TransactionBody syntheticTransferOrTransferFrom(@NonNull AccountID spenderId) {
        AccountID receiverId = this.addressIdConverter.convertCredit(this.to);
        AccountID ownerId = this.from == null ? spenderId : this.addressIdConverter.convert(this.from);
        return TransactionBody.newBuilder().cryptoTransfer(CryptoTransferTransactionBody.newBuilder().tokenTransfers(new TokenTransferList[]{TokenTransferList.newBuilder().token(this.tokenId).transfers(new AccountAmount[]{AccountAmount.newBuilder().accountID(receiverId).amount(this.amount).build(), AccountAmount.newBuilder().accountID(ownerId).amount(-this.amount).isApproval(this.requiresApproval || !spenderId.equals((Object)ownerId)).build()}).build()})).build();
    }
}

