/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.Erc20TransfersCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer.SpecialRewardReceivers;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class Erc20TransfersTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod ERC_20_TRANSFER = SystemContractMethod.declare("transfer(address,uint256)", "(bool)").withVia(SystemContractMethod.CallVia.PROXY).withCategories(SystemContractMethod.Category.ERC20, SystemContractMethod.Category.TRANSFER);
    public static final SystemContractMethod ERC_20_TRANSFER_FROM = SystemContractMethod.declare("transferFrom(address,address,uint256)", "(bool)").withVia(SystemContractMethod.CallVia.PROXY).withCategories(SystemContractMethod.Category.ERC20, SystemContractMethod.Category.TRANSFER);

    @Inject
    public Erc20TransfersTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(ERC_20_TRANSFER, ERC_20_TRANSFER_FROM);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        if (!attempt.isRedirect()) {
            return Optional.empty();
        }
        if (attempt.redirectTokenType() == TokenType.NON_FUNGIBLE_UNIQUE) {
            return Optional.empty();
        }
        return attempt.isMethod(ERC_20_TRANSFER, ERC_20_TRANSFER_FROM);
    }

    @Override
    @Nullable
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(ERC_20_TRANSFER)) {
            Tuple call = ERC_20_TRANSFER.decodeCall(attempt.input().toArrayUnsafe());
            return this.callFrom(null, (Address)call.get(0), (BigInteger)call.get(1), attempt, false);
        }
        Tuple call = ERC_20_TRANSFER_FROM.decodeCall(attempt.input().toArrayUnsafe());
        return this.callFrom((Address)call.get(0), (Address)call.get(1), (BigInteger)call.get(2), attempt, true);
    }

    private Erc20TransfersCall callFrom(@Nullable Address from, @NonNull Address to, @NonNull BigInteger amount, @NonNull HtsCallAttempt attempt, boolean requiresApproval) {
        return new Erc20TransfersCall(attempt.systemContractGasCalculator(), attempt.enhancement(), amount.longValueExact(), from, to, Objects.requireNonNull(attempt.redirectToken()).tokenIdOrThrow(), attempt.defaultVerificationStrategy(), attempt.senderId(), attempt.addressIdConverter(), requiresApproval, SpecialRewardReceivers.SPECIAL_REWARD_RECEIVERS);
    }
}

