/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.utils;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SystemContractMethodRegistry {
    private static final int EXPECTED_SYSTEM_CONTRACT_METHODS_UPPER_BOUND = 250;
    private final ConcurrentHashMap<String, SystemContractMethod> byName = new ConcurrentHashMap(250);
    private final ConcurrentHashMap<SystemContractMethod, SystemContractMethod> withoutToWithSystemContract = new ConcurrentHashMap(250);

    @Inject
    public SystemContractMethodRegistry() {
        Objects.requireNonNull(SystemContractMethod.SystemContract.HTS);
    }

    public void register(@NonNull SystemContractMethod systemContractMethodWithoutContract, @NonNull SystemContractMethod systemContractMethodWithContract) {
        Objects.requireNonNull(systemContractMethodWithoutContract);
        Objects.requireNonNull(systemContractMethodWithContract);
        Object keyName = systemContractMethodWithContract.variatedMethodName();
        if (systemContractMethodWithContract.via() == SystemContractMethod.CallVia.PROXY) {
            keyName = (String)keyName + systemContractMethodWithContract.via().asSuffix();
        }
        this.byName.putIfAbsent((String)keyName, systemContractMethodWithContract);
        this.withoutToWithSystemContract.putIfAbsent(systemContractMethodWithoutContract, systemContractMethodWithContract);
    }

    public long size() {
        return this.byName.size();
    }

    @NonNull
    public SystemContractMethod fromMissingContractGetWithContract(@NonNull SystemContractMethod systemContractMethodWithoutContract) {
        if (systemContractMethodWithoutContract.systemContract().isPresent()) {
            return systemContractMethodWithoutContract;
        }
        return this.withoutToWithSystemContract.get(systemContractMethodWithoutContract);
    }

    @NonNull
    public SequencedCollection<String> allQualifiedMethods() {
        return this.allMethodsGivenMapper(SystemContractMethod::qualifiedMethodName);
    }

    @NonNull
    public SequencedCollection<String> allSignatures() {
        return this.allMethodsGivenMapper(SystemContractMethod::signature);
    }

    @NonNull
    public SequencedCollection<String> allSignaturesWithReturns() {
        return this.allMethodsGivenMapper(SystemContractMethod::signatureWithReturn);
    }

    @NonNull
    public SequencedCollection<String> allMethodsGivenMapper(@NonNull Function<SystemContractMethod, String> methodMapper) {
        return this.byName.values().stream().map(methodMapper).sorted().toList();
    }

    @NonNull
    public Collection<SystemContractMethod> allMethods() {
        return this.byName.values();
    }

    @VisibleForTesting
    @NonNull
    public String allMethodsAsTable() {
        List<SystemContractMethod> allMethods = this.allMethods().stream().sorted(Comparator.comparing(SystemContractMethod::qualifiedMethodName)).toList();
        StringBuilder sb = new StringBuilder();
        for (SystemContractMethod method : allMethods) {
            String categoriesSuffix = method.categoriesSuffix();
            categoriesSuffix = categoriesSuffix.isEmpty() ? "No Category" : categoriesSuffix.substring(1);
            sb.append("%s: 0x%s - %s - %s\n".formatted(method.qualifiedMethodName(), method.selectorHex(), method.signatureWithReturn(), categoriesSuffix));
        }
        return sb.toString();
    }
}

