/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer.customfees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.FixedCustomFee;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.AssessmentResult;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomFixedFeeAssessor;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomFractionalFeeAssessor;
import com.hedera.node.app.service.token.impl.handlers.transfer.customfees.CustomRoyaltyFeeAssessor;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CustomFeeAssessor
extends BaseTokenHandler {
    private final CustomFixedFeeAssessor fixedFeeAssessor;
    private final CustomFractionalFeeAssessor fractionalFeeAssessor;
    private final CustomRoyaltyFeeAssessor royaltyFeeAssessor;
    private int initialNftChanges = 0;

    @Inject
    public CustomFeeAssessor(@NonNull CustomFixedFeeAssessor fixedFeeAssessor, @NonNull CustomFractionalFeeAssessor fractionalFeeAssessor, @NonNull CustomRoyaltyFeeAssessor royaltyFeeAssessor) {
        this.fixedFeeAssessor = fixedFeeAssessor;
        this.fractionalFeeAssessor = fractionalFeeAssessor;
        this.royaltyFeeAssessor = royaltyFeeAssessor;
    }

    private int numNftTransfers(CryptoTransferTransactionBody op) {
        List tokenTransfers = op.tokenTransfers();
        int nftTransfers = 0;
        for (TokenTransferList xfer : tokenTransfers) {
            nftTransfers += xfer.nftTransfers().size();
        }
        return nftTransfers;
    }

    public void assess(AccountID sender, Token token, AccountID receiver, AssessmentResult result, ReadableTokenRelationStore tokenRelStore, ReadableAccountStore accountStore, Predicate<AccountID> autoCreationTest) {
        this.fixedFeeAssessor.assessFixedFees(token, sender, result);
        this.revalidateAssessmentResult(result, tokenRelStore, accountStore, autoCreationTest);
        if (token.tokenType().equals((Object)TokenType.FUNGIBLE_COMMON)) {
            this.fractionalFeeAssessor.assessFractionalFees(token, sender, result);
        } else {
            this.royaltyFeeAssessor.assessRoyaltyFees(token, sender, receiver, result);
        }
        this.revalidateAssessmentResult(result, tokenRelStore, accountStore, autoCreationTest);
    }

    public void setTransactionFeesAsAssessed(@NonNull AccountID payer, @NonNull FixedCustomFee fee, @NonNull AssessmentResult result) {
        this.fixedFeeAssessor.setTransactionFeesAsAssessed(payer, fee, result);
    }

    private void revalidateAssessmentResult(AssessmentResult result, ReadableTokenRelationStore tokenRelStore, ReadableAccountStore accountStore, @NonNull Predicate<AccountID> autoCreationTest) {
        result.getHbarAdjustments().forEach((k, v) -> {
            if (v < 0L) {
                HandleException.validateFalse((boolean)autoCreationTest.test((AccountID)k), (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE);
            }
        });
        for (Map.Entry<TokenID, Map<AccountID, Long>> entry : result.getHtsAdjustments().entrySet()) {
            Map<AccountID, Long> entryValue = entry.getValue();
            for (Map.Entry<AccountID, Long> entryTx : entryValue.entrySet()) {
                Long htsBalanceChange = entryTx.getValue();
                AccountID accountId = entryTx.getKey();
                TokenRelation tokenRel = tokenRelStore.get(accountId, entry.getKey());
                if (htsBalanceChange > 0L && tokenRel == null) {
                    Account currentAccount = accountStore.getAccountById(accountId);
                    boolean mayBeAutoAssociatedHere = currentAccount != null && (currentAccount.maxAutoAssociations() > currentAccount.usedAutoAssociations() || currentAccount.maxAutoAssociations() == -1);
                    HandleException.validateTrue((boolean)mayBeAutoAssociatedHere, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR);
                }
                if (htsBalanceChange >= 0L) continue;
                Map<AccountID, Long> precedingChanges = result.getImmutableInputTokenAdjustments().get(entry.getKey());
                long precedingAdjustment = precedingChanges == null ? 0L : precedingChanges.getOrDefault(accountId, 0L);
                long precedingCredit = Math.max(0L, precedingAdjustment);
                if (tokenRel != null) continue;
                if (autoCreationTest.test(accountId)) {
                    throw new HandleException(ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE);
                }
                Account currentAccount = accountStore.getAccountById(accountId);
                boolean mayBeAutoAssociatedHere = currentAccount != null && precedingCredit > 0L && currentAccount.maxAutoAssociations() > currentAccount.usedAutoAssociations();
                if (mayBeAutoAssociatedHere) continue;
                throw new HandleException(ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT);
            }
        }
    }

    public void calculateAndSetInitialNftChanges(CryptoTransferTransactionBody op) {
        this.initialNftChanges = this.numNftTransfers(op);
    }

    public void resetInitialNftChanges() {
        this.initialNftChanges = 0;
    }
}

