/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import io.helidon.metrics.api.ScopeConfigBlueprint;
import io.helidon.metrics.api.ScopeConfigSupport;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.metrics.api.ScopeConfigBlueprint")
public interface ScopeConfig
extends ScopeConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ScopeConfig instance) {
        return (Builder)ScopeConfig.builder().from(instance);
    }

    public static ScopeConfig create(Config config) {
        return ((Builder)ScopeConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static ScopeConfig create(io.helidon.common.config.Config config) {
        return ScopeConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static ScopeConfig create() {
        return ScopeConfig.builder().buildPrototype();
    }

    @Override
    public boolean isMeterEnabled(String var1);

    @Override
    public String name();

    @Override
    public boolean enabled();

    @Override
    public Optional<Pattern> include();

    @Override
    public Optional<Pattern> exclude();

    public static class Builder
    extends BuilderBase<Builder, ScopeConfig>
    implements io.helidon.common.Builder<Builder, ScopeConfig> {
        private Builder() {
        }

        public ScopeConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ScopeConfigImpl(this);
        }

        public ScopeConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ScopeConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean enabled = true;
        private Config config;
        private Pattern exclude;
        private Pattern include;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(ScopeConfig prototype) {
            this.name(prototype.name());
            this.enabled(prototype.enabled());
            this.include(prototype.include());
            this.exclude(prototype.exclude());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.name().ifPresent(this::name);
            this.enabled(builder.enabled());
            builder.include().ifPresent(this::include);
            builder.exclude().ifPresent(this::exclude);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER include(String includeString) {
            ScopeConfigSupport.include(this, includeString);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER exclude(String excludeString) {
            ScopeConfigSupport.exclude(this, excludeString);
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("filter.include").as(Pattern.class).ifPresent(this::include);
            config.get("filter.exclude").as(Pattern.class).ifPresent(this::exclude);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearInclude() {
            this.include = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER include(Pattern include) {
            Objects.requireNonNull(include);
            this.include = include;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearExclude() {
            this.exclude = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER exclude(Pattern exclude) {
            Objects.requireNonNull(exclude);
            this.exclude = exclude;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Optional<Pattern> include() {
            return Optional.ofNullable(this.include);
        }

        public Optional<Pattern> exclude() {
            return Optional.ofNullable(this.exclude);
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ScopeConfigBuilder{name=" + this.name + ",enabled=" + this.enabled + ",include=" + String.valueOf(this.include) + ",exclude=" + String.valueOf(this.exclude) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER include(Optional<? extends Pattern> include) {
            Objects.requireNonNull(include);
            this.include = include.map(Pattern.class::cast).orElse(this.include);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER exclude(Optional<? extends Pattern> exclude) {
            Objects.requireNonNull(exclude);
            this.exclude = exclude.map(Pattern.class::cast).orElse(this.exclude);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ScopeConfigImpl
        implements ScopeConfig {
            private final boolean enabled;
            private final Optional<Pattern> exclude;
            private final Optional<Pattern> include;
            private final String name;

            protected ScopeConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name().get();
                this.enabled = builder.enabled();
                this.include = builder.include().map(Function.identity());
                this.exclude = builder.exclude().map(Function.identity());
            }

            @Override
            public boolean isMeterEnabled(String name) {
                return ScopeConfigSupport.isMeterEnabled(this, name);
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public Optional<Pattern> include() {
                return this.include;
            }

            @Override
            public Optional<Pattern> exclude() {
                return this.exclude;
            }

            public String toString() {
                return "ScopeConfig{name=" + this.name + ",enabled=" + this.enabled + ",include=" + String.valueOf(this.include) + ",exclude=" + String.valueOf(this.exclude) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ScopeConfig)) {
                    return false;
                }
                ScopeConfig other = (ScopeConfig)o;
                return Objects.equals(this.name, other.name()) && this.enabled == other.enabled() && Objects.equals(this.include, other.include()) && Objects.equals(this.exclude, other.exclude());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.enabled, this.include, this.exclude);
            }
        }
    }
}

