/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl.producers.formats;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.NodeAddress;
import com.hedera.hapi.node.base.NodeAddressBook;
import com.hedera.hapi.node.state.file.File;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.records.SelfNodeAccountIdManager;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.util.FileUtilities;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class SelfNodeAccountIdManagerImpl
implements SelfNodeAccountIdManager {
    private static final Logger logger = LogManager.getLogger(SelfNodeAccountIdManagerImpl.class);
    private final ConfigProvider configProvider;
    private final NodeInfo nodeInfo;
    private final State state;
    private final AtomicReference<AccountID> accountId = new AtomicReference();

    public SelfNodeAccountIdManagerImpl(@NonNull ConfigProvider configProvider, @NonNull NetworkInfo networkInfo, @NonNull State state) {
        this.configProvider = Objects.requireNonNull(configProvider);
        this.nodeInfo = Objects.requireNonNull(networkInfo).selfNodeInfo();
        this.state = Objects.requireNonNull(state);
    }

    public AccountID getSelfNodeAccountId() {
        if (this.accountId.get() == null) {
            this.initSelfNodeAccountId();
        }
        return this.accountId.get();
    }

    public void setSelfNodeAccountId(@NonNull AccountID accountId) {
        this.accountId.set(Objects.requireNonNull(accountId));
    }

    private void initSelfNodeAccountId() {
        if (this.state == null) {
            this.accountId.set(this.nodeInfo.accountId());
            return;
        }
        VersionedConfiguration config = this.configProvider.getConfiguration();
        FilesConfig filesConfig = (FilesConfig)config.getConfigData(FilesConfig.class);
        try {
            Bytes bytes;
            FileID nodeDetailsId = FileUtilities.createFileID(filesConfig.nodeDetails(), (Configuration)config);
            ReadableFileStore fileStore = new ReadableStoreFactory(this.state).getStore(ReadableFileStore.class);
            File nodeDetailsFile = fileStore.getFileLeaf(nodeDetailsId);
            Bytes bytes2 = bytes = nodeDetailsFile == null ? Bytes.EMPTY : nodeDetailsFile.contents();
            if (bytes.length() == 0L) {
                logger.info("Node details file ({}) missing or empty; falling back to self NodeInfo", (Object)filesConfig.nodeDetails());
                this.accountId.set(this.nodeInfo.accountId());
                return;
            }
            NodeAddressBook book = (NodeAddressBook)NodeAddressBook.PROTOBUF.parse(bytes);
            long selfNodeId = this.nodeInfo.nodeId();
            Optional<NodeAddress> maybeEntry = book.nodeAddress().stream().filter(addr -> addr.nodeId() == selfNodeId).findFirst();
            if (maybeEntry.isPresent() && maybeEntry.get().hasNodeAccountId()) {
                this.accountId.set(maybeEntry.get().nodeAccountIdOrThrow());
            } else {
                logger.warn("Self node id {} not found in node details; using NodeInfo account id", (Object)selfNodeId);
                this.accountId.set(this.nodeInfo.accountId());
            }
        }
        catch (ParseException e) {
            logger.warn("Failed to parse node details (file {}); using NodeInfo account id", (Object)filesConfig.nodeDetails(), (Object)e);
            this.accountId.set(this.nodeInfo.accountId());
        }
    }
}

