/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.cancelairdrops;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.PendingAirdropId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.TokenCancelAirdropTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.cancelairdrops.TokenCancelAirdropTranslator;
import com.hedera.node.app.service.contract.impl.exec.utils.PendingAirdropsHelper;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import javax.inject.Inject;

public class TokenCancelAirdropDecoder {
    private static final int TRANSFER_LIST = 0;
    private static final int HRC_RECEIVER = 0;
    private static final int HRC_SERIAL = 1;

    @Inject
    public TokenCancelAirdropDecoder() {
    }

    public TransactionBody decodeCancelAirdrop(@NonNull HtsCallAttempt attempt) {
        Tuple call = TokenCancelAirdropTranslator.CANCEL_AIRDROPS.decodeCall(attempt.inputBytes());
        int maxPendingAirdropsToCancel = ((TokensConfig)attempt.configuration().getConfigData(TokensConfig.class)).maxAllowedPendingAirdropsToCancel();
        Tuple[] transferList = (Tuple[])call.get(0);
        HandleException.validateFalse((transferList.length > maxPendingAirdropsToCancel ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.PENDING_AIRDROP_ID_LIST_TOO_LONG);
        List<PendingAirdropId> pendingAirdrops = PendingAirdropsHelper.decodePendingAirdrops(attempt, transferList);
        return TransactionBody.newBuilder().tokenCancelAirdrop(TokenCancelAirdropTransactionBody.newBuilder().pendingAirdrops(pendingAirdrops)).build();
    }

    public TransactionBody decodeCancelAirdropFT(@NonNull HtsCallAttempt attempt) {
        Tuple call = TokenCancelAirdropTranslator.HRC_CANCEL_AIRDROP_FT.decodeCall(attempt.inputBytes());
        AccountID senderId = attempt.senderId();
        Address receiverAddress = (Address)call.get(0);
        TokenID token = attempt.redirectTokenId();
        HandleException.validateTrue((token != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        AccountID receiverId = attempt.addressIdConverter().convert(receiverAddress);
        return TransactionBody.newBuilder().tokenCancelAirdrop(TokenCancelAirdropTransactionBody.newBuilder().pendingAirdrops(new PendingAirdropId[]{PendingAirdropsHelper.pendingFTAirdrop(senderId, receiverId, token)})).build();
    }

    public TransactionBody decodeCancelAirdropNFT(@NonNull HtsCallAttempt attempt) {
        Tuple call = TokenCancelAirdropTranslator.HRC_CANCEL_AIRDROP_NFT.decodeCall(attempt.inputBytes());
        AccountID senderId = attempt.senderId();
        Address receiverAddress = (Address)call.get(0);
        long serial = (Long)call.get(1);
        TokenID token = attempt.redirectTokenId();
        HandleException.validateTrue((token != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        AccountID receiverId = attempt.addressIdConverter().convert(receiverAddress);
        return TransactionBody.newBuilder().tokenCancelAirdrop(TokenCancelAirdropTransactionBody.newBuilder().pendingAirdrops(new PendingAirdropId[]{PendingAirdropsHelper.pendingNFTAirdrop(senderId, receiverId, token, serial)})).build();
    }
}

