/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.HookCall;
import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.hooks.HookCreation;
import com.hedera.hapi.node.hooks.HookCreationDetails;
import com.hedera.hapi.node.hooks.HookDispatchTransactionBody;
import com.hedera.hapi.node.hooks.HookExecution;
import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.node.app.service.contract.impl.ContractServiceComponent;
import com.hedera.node.app.service.contract.impl.exec.CallOutcome;
import com.hedera.node.app.service.contract.impl.exec.TransactionComponent;
import com.hedera.node.app.service.contract.impl.handlers.AbstractContractTransactionHandler;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.state.EvmFrameStates;
import com.hedera.node.app.service.contract.impl.state.WritableEvmHookStore;
import com.hedera.node.app.service.contract.impl.state.hooks.HookEvmFrameStateFactory;
import com.hedera.node.app.service.contract.impl.utils.HookValidationUtils;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.token.records.HookDispatchStreamBuilder;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.HooksConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

public class HookDispatchHandler
extends AbstractContractTransactionHandler
implements TransactionHandler {
    @Inject
    public HookDispatchHandler(@NonNull Provider<TransactionComponent.Factory> provider, @NonNull GasCalculator gasCalculator, @NonNull EntityIdFactory entityIdFactory, @NonNull ContractServiceComponent component) {
        super(provider, gasCalculator, entityIdFactory, component);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        HookDispatchTransactionBody op = context.body().hookDispatchOrThrow();
        PreCheckException.validateTruePreCheck((op.hasCreation() || op.hasExecution() || op.hasHookIdToDelete() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        if (op.hasCreation()) {
            PreCheckException.validateTruePreCheck((boolean)op.creationOrThrow().hasDetails(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_CREATION_SPEC);
            HookValidationUtils.validateHook(op.creationOrThrow().detailsOrThrow());
        } else if (op.hasExecution()) {
            HandleException.validateTrue((boolean)op.executionOrThrow().hasCall(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_CALL);
            HandleException.validateTrue((boolean)op.executionOrThrow().callOrThrow().hasHookId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_HOOK_CALL);
            HandleException.validateTrue((op.executionOrThrow().callOrThrow().evmHookCallOrThrow().gasLimit() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        WritableEvmHookStore evmHookStore = (WritableEvmHookStore)context.storeFactory().writableStore(WritableEvmHookStore.class);
        HookDispatchTransactionBody op = context.body().hookDispatchOrThrow();
        HookDispatchStreamBuilder recordBuilder = (HookDispatchStreamBuilder)context.savepointStack().getBaseBuilder(HookDispatchStreamBuilder.class);
        HooksConfig hooksConfig = (HooksConfig)context.configuration().getConfigData(HooksConfig.class);
        HandleException.validateTrue((boolean)hooksConfig.hooksEnabled(), (ResponseCodeEnum)ResponseCodeEnum.HOOKS_NOT_ENABLED);
        switch ((HookDispatchTransactionBody.ActionOneOfType)op.action().kind()) {
            case CREATION: {
                HookCreation creation = op.creationOrThrow();
                HookCreationDetails details = creation.detailsOrThrow();
                EvmHookState hook = evmHookStore.getEvmHook(new HookId(creation.entityId(), details.hookId()));
                HandleException.validateTrue((hook == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_ID_IN_USE);
                if (details.hasAdminKey()) {
                    context.attributeValidator().validateKey(details.adminKeyOrThrow(), ResponseCodeEnum.INVALID_HOOK_ADMIN_KEY);
                }
                int updatedSlots = evmHookStore.createEvmHook(op.creationOrThrow(), hooksConfig.maxNumberOfHooks());
                recordBuilder.setDeltaStorageSlotsUpdated(updatedSlots);
                break;
            }
            case HOOK_ID_TO_DELETE: {
                HookId deletion = op.hookIdToDeleteOrThrow();
                EvmHookState hook = evmHookStore.getEvmHook(new HookId(deletion.entityId(), deletion.hookId()));
                HandleException.validateTrue((hook != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_NOT_FOUND);
                evmHookStore.remove(op.hookIdToDeleteOrThrow());
                if (hook.nextHookId() == null) break;
                recordBuilder.nextHookId(hook.nextHookId());
                break;
            }
            case EXECUTION: {
                HookExecution execution = op.executionOrThrow();
                HookCall call = execution.callOrThrow();
                HookId hookKey = new HookId(execution.hookEntityIdOrThrow(), call.hookIdOrThrow().longValue());
                EvmHookState hook = evmHookStore.getEvmHook(hookKey);
                HandleException.validateTrue((hook != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_NOT_FOUND);
                EvmFrameStates evmFrameStates = (ops, nativeOps, codeFactory) -> new HookEvmFrameStateFactory(ops, nativeOps, codeFactory, hook);
                TransactionComponent component = this.getTransactionComponent(context, HederaFunctionality.CONTRACT_CALL, evmFrameStates);
                CallOutcome outcome = component.contextTransactionProcessor().call();
                ContractCallStreamBuilder streamBuilder = (ContractCallStreamBuilder)context.savepointStack().getBaseBuilder(ContractCallStreamBuilder.class);
                outcome.addCallDetailsTo(streamBuilder, context, this.entityIdFactory);
                HandleException.validateTrue((outcome.status() == ResponseCodeEnum.SUCCESS ? 1 : 0) != 0, (ResponseCodeEnum)outcome.status());
            }
        }
    }

    @Override
    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        return Fees.FREE;
    }
}

