/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.networkadmin.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenFreezeStatus;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenKycStatus;
import com.hedera.hapi.node.base.TokenRelationship;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountApprovalForAllAllowance;
import com.hedera.hapi.node.state.token.AccountCryptoAllowance;
import com.hedera.hapi.node.state.token.AccountFungibleTokenAllowance;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.GetAccountDetailsQuery;
import com.hedera.hapi.node.token.GetAccountDetailsResponse;
import com.hedera.hapi.node.token.GrantedCryptoAllowance;
import com.hedera.hapi.node.token.GrantedNftAllowance;
import com.hedera.hapi.node.token.GrantedTokenAllowance;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoOpsUsage;
import com.hedera.node.app.hapi.fees.usage.crypto.ExtantCryptoContext;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.networkadmin.impl.utils.NetworkAdminServiceUtil;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.PaidQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.TokensConfig;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NetworkGetAccountDetailsHandler
extends PaidQueryHandler {
    private final CryptoOpsUsage cryptoOpsUsage;

    @Inject
    public NetworkGetAccountDetailsHandler(CryptoOpsUsage cryptoOpsUsage) {
        this.cryptoOpsUsage = cryptoOpsUsage;
    }

    @NonNull
    public QueryHeader extractHeader(@NonNull Query query) {
        Objects.requireNonNull(query);
        return query.accountDetailsOrThrow().headerOrThrow();
    }

    @NonNull
    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        GetAccountDetailsResponse.Builder response = GetAccountDetailsResponse.newBuilder().header(header);
        return Response.newBuilder().accountDetails(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        GetAccountDetailsQuery op = context.query().accountDetailsOrThrow();
        if (!op.hasAccountId()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
        Account account = accountStore.getAliasedAccountById(op.accountIdOrThrow());
        Validations.mustExist((Object)account, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
    }

    @NonNull
    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        Query query = context.query();
        ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
        GetAccountDetailsQuery op = query.accountDetailsOrThrow();
        GetAccountDetailsResponse.Builder responseBuilder = GetAccountDetailsResponse.newBuilder();
        AccountID account = op.accountIdOrElse(AccountID.DEFAULT);
        LedgerConfig ledgerConfig = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        responseBuilder.header(header);
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK && responseType != ResponseType.COST_ANSWER) {
            ReadableTokenRelationStore tokenRelationStore;
            ReadableTokenStore readableTokenStore;
            TokensConfig tokensConfig = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
            Optional<GetAccountDetailsResponse.AccountDetails> optionalInfo = this.infoForAccount(account, accountStore, tokensConfig, readableTokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class), tokenRelationStore = (ReadableTokenRelationStore)context.createStore(ReadableTokenRelationStore.class), ledgerConfig);
            if (optionalInfo.isEmpty()) {
                responseBuilder.header(header.copyBuilder().nodeTransactionPrecheckCode(ResponseCodeEnum.FAIL_INVALID).build());
            } else {
                optionalInfo.ifPresent(arg_0 -> ((GetAccountDetailsResponse.Builder)responseBuilder).accountDetails(arg_0));
            }
        }
        return Response.newBuilder().accountDetails(responseBuilder).build();
    }

    private Optional<GetAccountDetailsResponse.AccountDetails> infoForAccount(@NonNull AccountID accountID, @NonNull ReadableAccountStore accountStore, @NonNull TokensConfig tokensConfig, @NonNull ReadableTokenStore readableTokenStore, @NonNull ReadableTokenRelationStore tokenRelationStore, @NonNull LedgerConfig ledgerConfig) {
        Account account = accountStore.getAliasedAccountById(accountID);
        if (account == null) {
            return Optional.empty();
        }
        GetAccountDetailsResponse.AccountDetails.Builder info = GetAccountDetailsResponse.AccountDetails.newBuilder();
        info.accountId(account.accountId());
        info.contractAccountId(NetworkAdminServiceUtil.asHexedEvmAddress(accountID));
        info.deleted(account.deleted());
        info.key(account.key());
        info.balance(account.tinybarBalance());
        info.receiverSigRequired(account.receiverSigRequired());
        info.expirationTime(Timestamp.newBuilder().seconds(account.expirationSecond()).build());
        info.autoRenewPeriod(Duration.newBuilder().seconds(account.autoRenewSeconds()).build());
        info.memo(account.memo());
        info.ownedNfts(account.numberOwnedNfts());
        info.maxAutomaticTokenAssociations(account.maxAutoAssociations());
        info.alias(account.alias());
        info.ledgerId(ledgerConfig.id());
        info.grantedCryptoAllowances(NetworkGetAccountDetailsHandler.getCryptoGrantedAllowancesList(account));
        info.grantedNftAllowances(NetworkGetAccountDetailsHandler.getNftGrantedAllowancesList(account));
        info.grantedTokenAllowances(NetworkGetAccountDetailsHandler.getFungibleGrantedTokenAllowancesList(account));
        List<TokenRelationship> tokenRels = this.tokenRelationshipsOf(tokensConfig.maxRelsPerInfoQuery(), account, readableTokenStore, tokenRelationStore);
        if (!tokenRels.isEmpty()) {
            info.tokenRelationships(tokenRels);
        }
        return Optional.of(info.build());
    }

    private List<TokenRelationship> tokenRelationshipsOf(long maxRelsPerInfoQuery, @NonNull Account account, @NonNull ReadableTokenStore readableTokenStore, @NonNull ReadableTokenRelationStore tokenRelationStore) {
        AccountID accountID;
        TokenRelation tokenRelation;
        Objects.requireNonNull(account);
        Objects.requireNonNull(tokenRelationStore);
        Objects.requireNonNull(readableTokenStore);
        ArrayList<TokenRelationship> ret = new ArrayList<TokenRelationship>();
        TokenID tokenId = account.headTokenId();
        int count = 0;
        while (tokenId != null && (long)count < maxRelsPerInfoQuery && (tokenRelation = tokenRelationStore.get(accountID = account.accountId(), tokenId)) != null) {
            Token token = readableTokenStore.get(tokenId);
            if (token != null) {
                this.addTokenRelation(ret, token, tokenRelation, tokenId);
            }
            tokenId = tokenRelation.nextToken();
            ++count;
        }
        return ret;
    }

    private void addTokenRelation(List<TokenRelationship> ret, Token token, TokenRelation tokenRelation, TokenID tokenId) {
        TokenFreezeStatus freezeStatus = TokenFreezeStatus.FREEZE_NOT_APPLICABLE;
        if (token.hasFreezeKey()) {
            freezeStatus = tokenRelation.frozen() ? TokenFreezeStatus.FROZEN : TokenFreezeStatus.UNFROZEN;
        }
        TokenKycStatus kycStatus = TokenKycStatus.KYC_NOT_APPLICABLE;
        if (token.hasKycKey()) {
            kycStatus = tokenRelation.kycGranted() ? TokenKycStatus.GRANTED : TokenKycStatus.REVOKED;
        }
        TokenRelationship tokenRelationship = TokenRelationship.newBuilder().tokenId(tokenId).symbol(token.symbol()).balance(tokenRelation.balance()).decimals(token.decimals()).kycStatus(kycStatus).freezeStatus(freezeStatus).automaticAssociation(tokenRelation.automaticAssociation()).build();
        ret.add(tokenRelationship);
    }

    private static List<GrantedNftAllowance> getNftGrantedAllowancesList(Account account) {
        if (!account.approveForAllNftAllowances().isEmpty()) {
            ArrayList<GrantedNftAllowance> nftAllowances = new ArrayList<GrantedNftAllowance>();
            for (AccountApprovalForAllAllowance a : account.approveForAllNftAllowances()) {
                GrantedNftAllowance.Builder approveForAllNftsAllowance = GrantedNftAllowance.newBuilder();
                approveForAllNftsAllowance.tokenId(a.tokenId());
                approveForAllNftsAllowance.spender(a.spenderId());
                nftAllowances.add(approveForAllNftsAllowance.build());
            }
            return nftAllowances;
        }
        return Collections.emptyList();
    }

    private static List<GrantedTokenAllowance> getFungibleGrantedTokenAllowancesList(Account account) {
        if (!account.tokenAllowances().isEmpty()) {
            ArrayList<GrantedTokenAllowance> tokenAllowances = new ArrayList<GrantedTokenAllowance>();
            GrantedTokenAllowance.Builder tokenAllowance = GrantedTokenAllowance.newBuilder();
            for (AccountFungibleTokenAllowance a : account.tokenAllowances()) {
                tokenAllowance.tokenId(a.tokenId());
                tokenAllowance.spender(a.spenderId());
                tokenAllowance.amount(a.amount());
                tokenAllowances.add(tokenAllowance.build());
            }
            return tokenAllowances;
        }
        return Collections.emptyList();
    }

    private static List<GrantedCryptoAllowance> getCryptoGrantedAllowancesList(Account account) {
        if (!account.cryptoAllowances().isEmpty()) {
            ArrayList<GrantedCryptoAllowance> cryptoAllowances = new ArrayList<GrantedCryptoAllowance>();
            GrantedCryptoAllowance.Builder cryptoAllowance = GrantedCryptoAllowance.newBuilder();
            for (AccountCryptoAllowance a : account.cryptoAllowances()) {
                cryptoAllowance.spender(a.spenderId());
                cryptoAllowance.amount(a.amount());
                cryptoAllowances.add(cryptoAllowance.build());
            }
            return cryptoAllowances;
        }
        return Collections.emptyList();
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext queryContext) {
        Query query = queryContext.query();
        ReadableAccountStore accountStore = (ReadableAccountStore)queryContext.createStore(ReadableAccountStore.class);
        GetAccountDetailsQuery op = query.accountDetailsOrThrow();
        AccountID accountId = op.accountIdOrElse(AccountID.DEFAULT);
        Account account = accountStore.getAliasedAccountById(accountId);
        return queryContext.feeCalculator().legacyCalculate(sigValueObj -> this.usageGiven(query, account));
    }

    private FeeData usageGiven(Query query, Account account) {
        if (account == null) {
            return Fees.CONSTANT_FEE_DATA;
        }
        ExtantCryptoContext ctx = ExtantCryptoContext.newBuilder().setCurrentKey(CommonPbjConverters.fromPbj((Key)account.key())).setCurrentMemo(account.memo()).setCurrentExpiry(account.expirationSecond()).setCurrentNumTokenRels(account.numberAssociations()).setCurrentMaxAutomaticAssociations(account.maxAutoAssociations()).setCurrentCryptoAllowances(Collections.emptyMap()).setCurrentTokenAllowances(Collections.emptyMap()).setCurrentApproveForAllNftAllowances(Collections.emptySet()).build();
        return this.cryptoOpsUsage.cryptoInfoUsage(CommonPbjConverters.fromPbj((Query)query), ctx);
    }
}

