/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.grpc.core;

import io.grpc.Metadata;
import io.helidon.http.HeaderNames;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.Http2Headers;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class GrpcHeadersUtil {
    private GrpcHeadersUtil() {
    }

    public static void updateHeaders(WritableHeaders<?> headers, Metadata metadata) {
        Base64.Encoder encoder = Base64.getEncoder();
        metadata.keys().forEach(name -> {
            if (name.endsWith("-bin")) {
                Metadata.Key key = Metadata.Key.of((String)name, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
                byte[] binary = (byte[])metadata.get(key);
                headers.add(HeaderNames.create((String)name, (String)new String(encoder.encode(binary), StandardCharsets.US_ASCII)), new String[0]);
            } else {
                Metadata.Key key = Metadata.Key.of((String)name, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                Iterable ascii = metadata.getAll(key);
                if (ascii != null) {
                    ascii.forEach(v -> headers.add(HeaderNames.create((String)name), new String[]{v}));
                }
            }
        });
    }

    public static Metadata toMetadata(Http2Headers headers) {
        Base64.Decoder decoder = Base64.getDecoder();
        Metadata metadata = new Metadata();
        headers.httpHeaders().forEach(header -> {
            String name = header.name();
            if (name.endsWith("-bin")) {
                Metadata.Key key = Metadata.Key.of((String)name, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
                metadata.put(key, (Object)decoder.decode(header.valueBytes()));
            } else {
                Metadata.Key key = Metadata.Key.of((String)name, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                header.allValues().forEach(value -> metadata.put(key, value));
            }
        });
        return metadata;
    }
}

