/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.OverflowException;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class BalanceOperation
extends AbstractOperation {
    public BalanceOperation(GasCalculator gasCalculator) {
        super(49, "BALANCE", 1, 1, gasCalculator);
    }

    protected long cost(boolean accountIsWarm) {
        return this.gasCalculator().getBalanceOperationGasCost() + (accountIsWarm ? this.gasCalculator().getWarmStorageReadCost() : this.gasCalculator().getColdAccountAccessCost());
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        try {
            Address address = Words.toAddress(frame.popStackItem());
            boolean accountIsWarm = frame.warmUpAddress(address) || this.gasCalculator().isPrecompile(address);
            long cost = this.cost(accountIsWarm);
            if (frame.getRemainingGas() < cost) {
                return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
            }
            Account account = frame.getWorldUpdater().get(address);
            frame.pushStackItem((Bytes)(account == null ? Bytes.EMPTY : account.getBalance()));
            return new Operation.OperationResult(cost, null);
        }
        catch (UnderflowException ufe) {
            return new Operation.OperationResult(this.cost(true), ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
        }
        catch (OverflowException ofe) {
            return new Operation.OperationResult(this.cost(true), ExceptionalHaltReason.TOO_MANY_STACK_ITEMS);
        }
    }
}

