/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.validators;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StakingValidator {
    @Inject
    public StakingValidator() {
    }

    public static void validateStakedIdForCreation(boolean hasDeclineRewardChange, @NonNull String stakedIdKind, @Nullable AccountID stakedAccountIdInOp, @Nullable Long stakedNodeIdInOp, @NonNull ReadableAccountStore accountStore, @NonNull NetworkInfo networkInfo) {
        boolean hasStakingId;
        boolean bl = hasStakingId = stakedAccountIdInOp != null || stakedNodeIdInOp != null;
        if (!hasStakingId) {
            return;
        }
        HandleException.validateTrue((boolean)StakingValidator.isValidStakingIdForCreation(stakedIdKind, stakedAccountIdInOp, stakedNodeIdInOp), (ResponseCodeEnum)ResponseCodeEnum.INVALID_STAKING_ID);
        StakingValidator.validateStakedId(stakedIdKind, stakedAccountIdInOp, stakedNodeIdInOp, accountStore, networkInfo);
    }

    public static void validateStakedIdForUpdate(boolean hasDeclineRewardChange, @NonNull String stakedIdKind, @Nullable AccountID stakedAccountIdInOp, @Nullable Long stakedNodeIdInOp, @NonNull ReadableAccountStore accountStore, @NonNull NetworkInfo networkInfo) {
        boolean hasStakingId;
        boolean bl = hasStakingId = stakedAccountIdInOp != null || stakedNodeIdInOp != null;
        if (!hasStakingId) {
            return;
        }
        if (StakingValidator.isValidStakingSentinel(stakedIdKind, stakedAccountIdInOp, stakedNodeIdInOp)) {
            return;
        }
        StakingValidator.validateStakedId(stakedIdKind, stakedAccountIdInOp, stakedNodeIdInOp, accountStore, networkInfo);
    }

    private static void validateStakedId(@NonNull String stakedIdKind, @Nullable AccountID stakedAccountIdInOp, @Nullable Long stakedNodeIdInOp, @NonNull ReadableAccountStore accountStore, @NonNull NetworkInfo networkInfo) {
        if (stakedIdKind.equals("STAKED_ACCOUNT_ID")) {
            HandleException.validateTrue((accountStore.getAccountById(Objects.requireNonNull(stakedAccountIdInOp)) != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_STAKING_ID);
        } else if (stakedIdKind.equals("STAKED_NODE_ID")) {
            Objects.requireNonNull(stakedNodeIdInOp);
            HandleException.validateTrue((stakedNodeIdInOp >= -1L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_STAKING_ID);
            HandleException.validateTrue((networkInfo.nodeInfo(stakedNodeIdInOp.longValue()) != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_STAKING_ID);
        }
    }

    private static boolean isValidStakingSentinel(@NonNull String stakedIdKind, @Nullable AccountID stakedAccountId, @Nullable Long stakedNodeId) {
        if (stakedIdKind.equals("STAKED_ACCOUNT_ID")) {
            return Objects.requireNonNull(stakedAccountId).accountNumOrThrow() == 0L;
        }
        if (stakedIdKind.equals("STAKED_NODE_ID")) {
            return Objects.requireNonNull(stakedNodeId) == -1L;
        }
        return false;
    }

    private static boolean isValidStakingIdForCreation(String stakedIdKind, AccountID stakedAccountId, Long stakedNodeId) {
        if (stakedIdKind.equals("STAKED_ACCOUNT_ID")) {
            return Objects.requireNonNull(stakedAccountId).accountNumOrThrow() > 0L;
        }
        if (stakedIdKind.equals("STAKED_NODE_ID")) {
            return Objects.requireNonNull(stakedNodeId) >= 0L;
        }
        return false;
    }
}

