/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.model.internal.standard;

import com.swirlds.base.time.Time;
import com.swirlds.component.framework.model.StandardWiringModel;
import com.swirlds.component.framework.model.internal.standard.AbstractHeartbeatScheduler;
import com.swirlds.component.framework.model.internal.standard.HeartbeatTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Timer;
import java.util.TimerTask;

public class HeartbeatScheduler
extends AbstractHeartbeatScheduler {
    private final Timer timer = new Timer();

    public HeartbeatScheduler(@NonNull StandardWiringModel model, @NonNull Time time) {
        super(model, time);
    }

    @Override
    public void start() {
        if (this.started) {
            throw new IllegalStateException("Cannot start the heartbeat more than once");
        }
        this.started = true;
        for (HeartbeatTask task : this.tasks) {
            this.timer.scheduleAtFixedRate((TimerTask)task, 0L, task.getPeriod().toMillis());
        }
    }

    @Override
    public void stop() {
        if (!this.started) {
            throw new IllegalStateException("Cannot stop the heartbeat before it has started");
        }
        this.timer.cancel();
    }
}

