/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.utility;

import java.util.Objects;

public enum Threshold {
    STRONG_MINORITY(Threshold::isStrongMinority),
    MAJORITY(Threshold::isMajority),
    SUPER_MAJORITY(Threshold::isSuperMajority);

    private final ThresholdEvaluator evaluator;

    private Threshold(ThresholdEvaluator evaluator) {
        this.evaluator = Objects.requireNonNull(evaluator);
    }

    public boolean isSatisfiedBy(long part, long whole) {
        return this.evaluator.isSatisfiedBy(part, whole);
    }

    private static boolean isSuperMajority(long part, long whole) {
        return part > whole / 3L * 2L + whole % 3L * 2L / 3L;
    }

    private static boolean isStrongMinority(long part, long whole) {
        return part >= whole / 3L + (long)(whole % 3L == 0L ? 0 : 1);
    }

    private static boolean isMajority(long part, long whole) {
        return part >= whole / 2L + 1L;
    }

    @FunctionalInterface
    private static interface ThresholdEvaluator {
        public boolean isSatisfiedBy(long var1, long var3);
    }
}

